/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Signals failure to find object to be called. This exception will be 
 * throwon, if:
 * <UL>
 * <LI> no class found.
 * <LI> no daemon object with such object name found.
 * </UL>
 * The proxy object is not usable and no connection has made after this
 * exception.
 */
public class NoObjectException extends HORBException {
  public NoObjectException(String s) {
    super(s);
  }
  public NoObjectException(Exception e) {
    super(e.toString());
  }
}
