/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Exception to signal access permission error. This exception is raised
 * if
 * <UL>
 * <LI>Client's host or user is not allowed to access the object or the
 * method.
 * <LI>Password mismatch.
 * </UL>
 * @see ACL
 */
public class NoPermissionException extends HORBException {
  public NoPermissionException(String s) {
    super(s);
  }
  public NoPermissionException(Exception e) {
    super(e.toString());
  }
}
