/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;

import java.util.Hashtable;

/**
 * Item in a object table.
 */
class ObjectInfo {
  Skeleton skeleton;		// skeleton object
  ObjectStatus os;		// thread info structure

  ObjectInfo(String className, String objectID, Skeleton skeleton, int port, boolean daemon) {
    os = new ObjectStatus();
    add(className, objectID, skeleton, port, daemon);
  }

  final synchronized void add(String className, String objectID, Skeleton skeleton, int port, boolean daemon) {
    this.os.className = className;
    this.os.objectID = objectID;
    this.skeleton = skeleton;
    this.os.port = port;
    this.os.startTime = System.currentTimeMillis();
    this.os.daemon = daemon;
  }
  final synchronized int use() {
    synchronized (os) {
      os.numThread++;
      os.numConnect++;
      os.lastUsedTime = System.currentTimeMillis();
      if (os.numThread > os.maxThreads)
	os.maxThreads = os.numThread;
      return os.numThread;
    }
  }
  final synchronized int unuse() {
    synchronized (os) {
      os.numThread--;
      return os.numThread;
    }
  }
  final Skeleton getSkeleton() {
    return skeleton;
  }
  final String getObjectID() {
    return os.objectID;
  }

  final boolean isDaemon() {
    return os.daemon;
  }
}

