/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;

import java.io.*;
import horb.tools.util.*;

/**
 * 
 */
public class ObjectStatus implements Cloneable {

  /**
   * fully qualified class name or interface name.
   */
  public String className;

  /**
   * fully qualified class name of the implementation. This field is
   * used only when className is an interface.
   */
  public String implementation;

  /**
   * object name. Not URL.
   */
  public String objectID;

  /**
   * true if this is a daemon object (registered by registerInstance()).
   */
  public boolean daemon;

  /**
   * port number of this object. If 0, this object can be connected from 
   * any port.
   */
  public int port;

  /**
   * true if acceptance of connect request has been stopped.
   */
  public boolean stop;

  /**
   * current number of clients this object has.
   */
  public int numThread;

  /**
   * maximum number of threads ever made
   */
  public int maxThreads;		// maximum number of threads

  /**
   * time when this object was born. System.currentTimeMillis() format.
   */
  public long startTime;

  /**
   * time when last connection was made. System.currentTimeMillis() format.
   */
  public long lastUsedTime;

  /**
   * current time on the server system. System.currentTimeMillis() format.
   */
  public long currentTime;

  /**
   * number of connections (clients) ever built
   */
  public int numConnect;

  public ObjectStatus get() {
    try {
      return (ObjectStatus)this.clone();
    } catch (Exception e) {}
    return null;
  }

  public void list(PrintStream ps) {
    FormatDate startTime = new FormatDate(this.startTime);
    FormatDate lastUsedTime = new FormatDate(this.lastUsedTime);
    String sLastUsedTime;
    if (this.lastUsedTime == 0)
      sLastUsedTime = "NA";
    else
      sLastUsedTime = lastUsedTime.getYMDHMS();

    ps.println("\tobjectID: "+objectID);
    ps.println("\tclass name: "+className);
    ps.println("\timplementation: "+implementation);
    ps.println("\tport: "+port);
    ps.println("\tdaemon object: "+daemon);
    ps.println("\tstopped: "+stop);
    ps.println("\tstart time: "+startTime.getYMDHMS());
    ps.println("\tlast connected time: "+sLastUsedTime);

    ps.println("\tconnections ever made: "+numConnect);
    ps.println("\tmaxium number of simultaneous threads: "+maxThreads);
    ps.println("\tcurrent number of threads: "+numThread);
  }
  
}
