/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Signals failure to allocate a proxy object.
 * <UL>
 * <LI>Reconnection failure after object passing by reference.
 * <LI>Foo_Proxy.class or Foo_Skeleton.class not found during passing
 * an instance of Foo. 
 * This exception means you should prepare proper *_Proxy and *_Skeleton class
 * for a remote object. 
 * </UL>
 * This exception occures only when the strict flag
 * of IOCI is true. The default is false. If the strict flag is
 * false, ORB silently ignores the errors. That means that an exception may
 * occur when you use remote object reference that was passed remotely.
 * The proxy object is not usable after occuring of this exception.
 */
public class ProxyException extends HORBException {
  public ProxyException(String s) {
    super(s);
  }
  public ProxyException(Exception e) {
    super(e.toString());
  }
}
