/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

/**
 * Signals error occurs during executing a remote object. This exception
 * will be thrown if;
 * <NL>
 * <LI> exception occures during execution of the remote object.
 * </NL>
 * <p>
 * TIPS!
 * <p>
 * <UL>
 * <LI> RemoteException.toString() returns exception message of the remote
 * exception.
 * <LI> "horb -v" dumps stack trace when remote exception occurs.
 * </UL>
 *
 */
public class RemoteException extends HORBException {
  public RemoteException(String s) {
    super(s);
  }
  public RemoteException(Exception e) {
    super(e.toString());
  }
}
