/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.io.*;

/**
 * Restartable object. 
 *
 * <pre>
 * Typical usage:
 *     FileIOCI file = new FileIOCI(new HorbURL("file:///foo.fof"));
 *     Restartable object = file.load();
 *     object.restart();
 *
 *	// the object works here
 *
 *     // if you want to save it again...
 *     object.shutdown();
 *     file.save(object);
 *     
 * </pre>
 * A foffile saved like the above can be run by the fofrun command.
 * @see FileIOCI
 */
public interface Restartable {

  /**
   * restart a revived object. this method is called after
   * loading the object. Do work in this context.
   */
  public void restart() throws HORBException, IOException;

  /**
   * this method is called before saving the object. Various
   * shutdown operations should be performed in this method.
   */
  public void shutdown() throws HORBException, IOException;
}
