/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;

import java.io.*;
import horb.tools.util.*;

/**
 * 
 */
public class ServerStatus implements Cloneable {

  /**
   * name of this server
   */
  public String name;

  /**
   * major version of the HORB System
   */
  public short major_version;

  /**
   * minor version of the HORB System
   */
  public short minor_version;

  /**
   * system's IOCI class. Usually "horb.orb.BasicIOCI".
   */
  public String IOCIClassName;

  /**
   * major version of IOCI
   */
  public short IOCI_major_version;

  /**
   * minor version of IOCI
   */
  public short IOCI_minor_version;

  /**
   * port number the server serves.
   */
  public int port;

  /**
   * true if hostname lookup. but network address reverse resolution takes
   * time. default true.
   */
  public boolean hostnameLookup = true;

  /**
   * debugging condition.
   */
  public boolean debug = false;

  /**
   * logging condition.
   */
  public boolean logging = false;

  /**
   * true if check versions between proxy class and skeleton class
   */
  public boolean versionCheck = true;

  /**
   * log file.
   */
  public String logFile;

  /**
   * number of object the server has now.
   */
  public int numObject;

  /**
   * number of threads (client connections) the server has now.
   */
  public int numThread;

  /**
   * time when this server was born. System.currentTimeMillis() format.
   */
  public long startTime;

  /**
   * time when last connection was made. System.currentTimeMillis() format.
   */
  public long lastUsedTime;

  /**
   * current time on the server system. System.currentTimeMillis() format.
   */
  public long currentTime;

  public synchronized ServerStatus get() {
    try {
      currentTime = System.currentTimeMillis();
      numObject = HORBServer.objectTable.size();
      numThread = HORBServer.threadTable.size();
      return (ServerStatus)this.clone();
    } catch (Exception e) {}
    return null;
  }

  public void list(PrintStream ps) {
    FormatDate startTime = new FormatDate(this.startTime);
    FormatDate lastUsedTime = new FormatDate(this.lastUsedTime);
    FormatDate currentTime = new FormatDate(this.currentTime);

    ps.println("\tHORB Server name: " + name);

    ps.println("\tHORB version: "+major_version+"."+minor_version);
    ps.println("\tIOCI class: "+IOCIClassName+ " "+IOCI_major_version+"."+IOCI_minor_version);

    ps.println("\tstart time: "+startTime.getYMDHMS());
    if (this.lastUsedTime == 0)
      ps.println("\tlast used: NA");
    else
      ps.println("\tlast used: "+lastUsedTime.getYMDHMS());
    ps.println("\tcurrent time: "+currentTime.getYMDHMS());

    ps.println("\tserver port: "+port);
    ps.println("\thostname lookup: "+hostnameLookup);
    ps.println("\tdebug: "+debug);
    ps.println("\tlogging: "+logging);
    ps.println("\tversion check: "+versionCheck);
    ps.println("\tnumber of objects (in system): "+numObject);
    ps.println("\tnumber of threads (in system): "+numThread);
  }
}
