/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;

import java.util.*;

/**
 * ServerStatus Table.
 *
 */
class ServerTable extends Hashtable {

  /**
   * returns HORB server for the current thread.
   * @exception HORBException if the current thread  is not a HORB thread 
   *				or server's already dead.
   */
  final HORBServer getServer() throws HORBException {
    ThreadServer thread = (ThreadServer)HORBServer.threadTable.get(Thread.currentThread());
    if (thread == null)
      throw new HORBException("not HORB thread");
    HORBServer server = thread.server;
    if (server == null)
      throw new HORBException("server's alread dead");
    return server;
  }

  /**
   * returns HORB server for the port.
   * @param port  server port 
   * @exception HORBException HORB server not bound to the port
   */
  final synchronized HORBServer getServer(int port) throws HORBException {
    HORBServer hs = null;
    if (port == 0) {
      for (Enumeration e = elements(); e.hasMoreElements();) {
	hs = (HORBServer)e.nextElement();
	return hs;
      }
    } else {			// port != 0
      hs = (HORBServer)get(new Integer(port));
    }
    if (hs == null)
      throw new HORBException("HORB server not bound to the port");
    return hs;
  }

  /**
   * returns status of all HORB servers.
   */
  public final synchronized ServerStatus[] getServerStatus() {
    int size = size();
    ServerStatus[] ss = new ServerStatus[size];

    HORBServer hs = null;
    Enumeration e = elements();
    for (int i = 0; i < size && e.hasMoreElements(); i++) {
      hs = (HORBServer)e.nextElement();
      ss[i] = hs.ss.get();
      ss[i].name = hs.ss.name;
      ss[i].major_version = HORB.major_version;
      ss[i].minor_version = HORB.minor_version;
      ss[i].IOCIClassName = hs.ss.IOCIClassName;
      ss[i].IOCI_major_version = hs.ss.IOCI_major_version;
      ss[i].IOCI_minor_version = hs.ss.IOCI_minor_version;
      ss[i].port = hs.ss.port;
      ss[i].debug = hs.ss.debug;
      ss[i].logging = hs.ss.logging;
    }
    return ss;
  }

  /**
   * returns status of HORB server for the port.
   * @exception HORBException HORB server not bound to the port
   */
  public final synchronized ServerStatus getServerStatus(int port) throws HORBException {
    HORBServer hs = (HORBServer)get(new Integer(port));
    if (hs == null)
      new HORBException("HORB server not bound to the port");

    ServerStatus ss = hs.ss;
    ss.name = hs.ss.name;
    ss.major_version = HORB.major_version;
    ss.minor_version = HORB.minor_version;
    ss.IOCIClassName = hs.ss.IOCIClassName;
    ss.IOCI_major_version = hs.ss.IOCI_major_version;
    ss.IOCI_minor_version = hs.ss.IOCI_minor_version;
    ss.port = port;
    ss.debug = hs.ss.debug;
    ss.logging = hs.ss.logging;
    return ss;
  }
}
