/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */

package horb.orb;
import java.io.*;

/**
 * Skeleton object interface. If a server object needs the skeleton of
 * the current thread, call HORBServer.getSkeleton().
 *  <pre>
 *	Skeleton s = HORBServer.getSkeleton();
 *	s.accept(0);
 *  </pre>
 */
public interface Skeleton {
  /**
   * Returns major version number of this proxy class.
   */
  public short getMajorVersion();

  /**
   * Returns minor version number of this proxy class.
   */
  public short getMinorVersion();

  /**
   * accept invitation. Wait for the invitation while specified duration.
   * When invitation comes, this returns a proxy object to the invitor object.
   * In case of timeout, this returns null. 
   *
   * @param millis the maximum time to wait in milli seconds.
   * @return Proxy object of the invitor.
   */
  Proxy accept(long millis) throws InterruptedException;

  /**
   * returns true if already invited.
   */
  boolean isInvited();

  /**
   * (internal) Method dispatcher. A method stub routing selected by methodNo
   * receives arguments from ioci, then returns value to ioci.
   * @param ioci      communication channel
   * @param classNo   class number in class hierarchy
   * @param methodNo  method number in the class
   * @return true   if constructor fails
   * @exception IOException occurs when network error occurs.
   */
  public boolean dispatch(IOCI ioci, short classNo, short methodNo) 
    throws IOException;

  /**
   * (internal) set an object to this skeleton. This method is valid only once.
   * should be used for registerObject().
   * 
   * @param o object to be set. This must be the same type as the skeleton.
   */
  public void setObject(Object o) throws HORBException;

  /**
   * (internal) get an object of this skeleton.
   */
  public Object getObject() throws ClassNotFoundException, InstantiationException, IllegalAccessException;

  /**
   * (internal) calls HORB server's finalize().
   */
  public void threadEndHook();

  /**
   * (internal) Tells the invitation has come.
   */
  void invited(Proxy proxy);
}
