/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.orb;

import java.io.*;
import java.net.*;

/**
 * A test IOCI for TCP/IP. This is identical to BasicIOCI except
 * class name and signature.
 */
public final class TestIOCI extends BasicIOCI implements IOCI {
  /** major version number */
  public static final short major_version = 1;
  /** minor version number */
  public static final short minor_version = 0;
  /** 0x4832 is the signature of TestIOCI. Use another signature if you write
   * another IOCI.
   */
  public static final short signature = (short)0x4832;

  public short getSignature() {
    return signature;
  }
  public short getMajorVersion() {
    return major_version; 
  }
  public short getMinorVersion() {
    return minor_version; 
  }
}
