package horb.examples.accessControl;
import horb.orb.*;
import java.io.*;

class Client {
  HorbURL url;

  public static void main(String argv[]) throws HORBException, IOException {

    Client client = new Client(argv);

    System.out.println("trying as anonymous user");
    // equivalent to client.test(null, null);
    client.test("anonymous", null);

    // try as a real user
    String user = System.getProperty("user.name");
    System.out.println("trying as "+user);
    String pw = client.enterPw(user);
    client.test(user, pw);

    String user2 = "administrator";
    System.out.println("trying as "+user2);
    client.test(user2, null);
  }

  Client (String argv[]) throws HORBException {
    String host = (argv.length == 1) ? argv[0] : null;
    url = new HorbURL(host, null);
  }
    
  void test(String user, String pw) throws HORBException, IOException {
    try {
      Server_Proxy server = new Server_Proxy(url, user, pw);
      System.out.println(server.greeting());
      System.out.println(server.dangerous());
      server._release();
    } catch (NoPermissionException e) {
      System.err.println(user+" couldn't access object Server.");
    }
    System.out.println();
  }

  String enterPw(String user) throws IOException {
    System.err.print(user+"'s secret word: ");
    System.err.flush();
    byte buf[] = new byte[20];
    int len = System.in.read(buf);
    return (new String(buf, 0, 0, len)).trim();
  }
}

