package horb.examples.accessControl;

import horb.orb.*;

public class Server {
  public String greeting() throws HORBException {
    IOCIService ioci = HORBServer.getIOCIService();
    return ioci.getUsername()+" is allowed to access object Server.";
  }

  public String dangerous() throws HORBException {
    IOCIService ioci = HORBServer.getIOCIService();
    ACL acl = HORBServer.getSystemACL();
    if (acl.checkUser_Local("horb.examples.accessControl.Server.dangerous", ioci) == true)
      return ioci.getUsername()+" is allowed to access Server.dangerous()";
    else
      return ioci.getUsername()+" is NOT allowed to access Server.dangerous()";
  }
}
