package horb.examples.async;
import horb.orb.*;

class Client3 {
  static Server_Proxy server;

  public static void main(String argv[]) {
    String host = (argv.length == 1) ? argv[0] : "localhost";

    Client3 client = new Client3();
    server = new Server_Proxy("horb://"+host);
    
    System.out.println("Trial 1");
    client.test(2);

    System.out.println("\nTrial 2");
    client.test(5);
  }

  void test(int timeout) {
    try {
      server.work_Request(3, "Hi, baby!");
      System.out.println("Request sent");
      System.out.println("waiting for "+timeout+" sec");
      if (server._wait(timeout*1000) == true) {
	System.out.println("_wait("+timeout*1000+") returns true");
	System.out.println(server.work_Receive(0));
      } else {
	System.out.println("_wait("+timeout*1000+") returns false. timeout!");
	//
	// In HORB 1.2, you have to receive the result eventually.
	// Or, release the connection and then reconnect again to
	// put the result away.
	Server_Proxy tmp = new Server_Proxy(server._getObjectURL());
	server._release();
	server = tmp;
	System.out.println("reconnected to "+server._getObjectURL());
      }
    } catch (InterruptedException e) {}
  }
}
