package horb.examples.async;
import horb.orb.*;

class Client4 implements AsyncMethodHandler {
  Server_Proxy server;

  public static void main(String argv[]) {
    String host = (argv.length == 1) ? argv[0] : "-";

    Client4 client = new Client4();
    client.test(host);
  }

  void test(String host) {
    server = new Server_Proxy("horb://"+host);

    server._setHandler(this, 1); // 1 is tag.

    server.work_Request(3, "Hi, baby!");
    System.out.println("Request sent");

    System.out.println("sleep start");
    try {
      Thread.sleep(6*1000);
    } catch (InterruptedException e) {}
    System.out.println("sleep end");
  }

  public void run(int tag) {
    try {      
      System.out.println("entering callback object");
      System.out.println(server.work_Receive(0));
      System.out.println("leaving callback object");
    } catch (InterruptedException e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}
