package horb.examples.async;
import horb.orb.*;

class Client6 implements AsyncMethodHandler {
  Server_Proxy servers[];
  static final int numServer = 4;
  int tasks[] = {2, 3, 1, 4, 3, 2, 4, 3, 1, 2};
  int start;
  int finish;
  Object end = new Object();

  public static void main(String argv[]) {
    String host = (argv.length == 1) ? argv[0] : "localhost";

    Client6 client = new Client6();
    client.test(host);
  }

  void test(String host) {
    servers = new Server_Proxy[numServer];
    for (int i = 0; i < numServer; i++) {
      servers[i] = new Server_Proxy(new HorbURL(host, null));
      servers[i]._setHandler(this, i);
    }

    synchronized (end) {
      start = 0;
      finish = 0;
      // enter first tasks
      for (int i = 0; i < numServer; i++)
	enterTask(i);

      try {
	end.wait(0);		// wait for finish
      } catch (Exception e) {}
    }

    System.out.println("All tasks have done.");
  }

  synchronized void enterTask(int sid) {
    if (start < tasks.length) {
      System.out.println("start task at server["+sid+"]");
      servers[sid].work_Request(tasks[start], "hi, baby!");
      start++;
    }
  }

  public synchronized void run(int tag) {
    System.out.print("task at server["+tag+"] has done: ");
    try {
      System.out.println(servers[tag].work_Receive(0));
    } catch (InterruptedException e) {
      e.printStackTrace();
      System.exit(1);
    }
    if (++finish == tasks.length)
      synchronized (end) {
	end.notify();
      }
    enterTask(tag);
  }
}
