package horb.examples.foffile;

import horb.orb.*;
import java.io.*;

class Client implements Restartable {
  int counter;

  public static void main(String argv[]) throws HORBException, IOException {
    Client c = new Client();
    c.newrun();
  }

  void newrun() throws HORBException, IOException {

    work();

    // save the object
    FileIOCI file = new FileIOCI("client.fof");
    shutdown();
    file.save(this);

    System.out.println("I'm stored in client.fof.");
    System.out.println("Examine it by 'fofrun -info client.fof', then recover me by 'fofrun client.fof'!");
    System.out.println("Try 'fofrun -autosave client.fof client.fof', too");
  }

  Client() {}

  void work() {
    for (int i = 0; i < 10; i++) {
      System.out.println("counter = " + counter);
      counter++;
    }
  }

  public void restart() {
    System.out.println("restart(): I'm revived!");

    // HORB.setPort(8887); // set port number if required.

    work();
  }

  public void shutdown() {
    System.out.println("shutdown(): I'm shutting down! World becomes dark and dark...");
  }
}
