package horb.examples.invitation;

import horb.orb.*;

class Client {

  static Server_Proxy server;
  static HorbURL clientURL;

  public static void main(String argv[]) throws HORBException {
    String host = (argv.length == 1) ? argv[0] : "localhost";
    HORBServer hs = new HORBServer(-1, null, null);

    server = new Server_Proxy("horb://"+host);

    Client client = new Client();
    clientURL = HORBServer.registerObject("horb.examples.invitation.Client",
					  client, "testClient", 0);

    client.test();

    HORBServer.unRegisterObject(clientURL.getObjectID());
    System.exit(0);			// this is required.
  }

  synchronized void test() {
    ((Server_Proxy)server)._invite(clientURL, null, null);
    server.acceptInvitation();
    System.out.println("Server accepted my invitation");

    try {
      wait(0);			// wait for call by the server
      Thread.sleep(100);	// disconnect gracefully
    } catch (InterruptedException e) {}
  }

  public synchronized void clientMethod(String data) {
    System.out.println("called by server");
    System.out.println(data);

    notify();
  }
}
