package horb.examples.invitation2;

import java.awt.*;
import horb.orb.*;
import java.util.*;

public class Applet extends java.applet.Applet {

  String host;
  Server server;
  String remoteTime = "";
  HorbURL clientURL;

  public void init() {
    try {
      HORBServer hs = new HORBServer(-1, "portLessServer", null);
    } catch (Exception e) {}
  }

  public void start() {
    try {
      host = getDocumentBase().getHost();
    } catch (Exception e0) {}
    if (host == null || host.length() == 0)
      host = "localhost";

    try {
      server = new Server_Proxy("horb://"+host);

      clientURL = HORBServer.registerObject("horb.examples.invitation2.Applet",
					    this, "testApplet", 0);

      ((Server_Proxy)server)._invite(clientURL, null, null);
      server.acceptInvitation();
    } catch (Exception e) {
      e.printStackTrace();
    }
    resize(300,150);
    setFont(new Font("TimesRoman",Font.BOLD,48));
  }

  /** the method called by the server */
  public void serverPaint(String remoteTime) {
    this.remoteTime = remoteTime;
    repaint();
  }

  public void paint(Graphics g) {
    // get current local time and display it
    String localTime = currentTime();
    g.setColor(Color.blue);
    g.drawString(localTime, 40, 100);
    g.setColor(Color.red);
    g.drawString(remoteTime, 40, 60);
  }

  public void stop() {
    try {
      if (server != null)
	((Server_Proxy)server)._release();
      server = null;
      HORBServer.unRegisterObject(clientURL.getObjectID());
    } catch (Exception e) {}
  }

  public String currentTime() {
    Date date = new Date();	// get current system date and time
    String s;
    int hour = date.getHours();
    int min = date.getMinutes();
    int sec = date.getSeconds();
    s = ""+ hour/10 + hour%10 + ":" + min/10 + min%10 + ":" + sec/10 + sec%10;
    return s;
  }
}
