package horb.examples.multiServer;
import horb.orb.*;

public class Server {
  public static void main(String argv[]) throws HORBException {
    HORBAgent ha = new HORBAgent_Impl(); 	// for debugging

    // start two HORB servers and set debug flag
    HORBServer hs1 = new HORBServer(8887, "PortServer1", null);
    ha.setHORBServerDebug(8887, true); 		// for debugging
    HORBServer hs2 = new HORBServer(8886, "PortServer2", null);
    ha.setHORBServerDebug(8886, true);		// for debugging

    // 
    Server server1 = new Server();
    HORBServer.registerObject("horb.examples.multiServer.Server", 
			      server1, "server8887", 8887);

    Server server2 = new Server();
    HORBServer.registerObject("horb.examples.multiServer.Server", 
			      server2, "server8886", 8886);

    //
    // Now instances of HORBServer are waiting for requests.
    //
  }

  String whoAreYou() {
    try {
      return "You came from " +HORBServer.getClientHostName()
	+" port "+HORBServer.getCurrentPort() +".";
    } catch (Exception e) {
      return "I don't know you.";
    }
  }
}
