package horb.examples.objectStorage;

import horb.orb.*;
import java.io.*;

class Client {

  public static void main(String argv[]) throws HORBException, IOException {

    String fname = "data.fof";

    String host = (argv.length == 1) ? argv[0] : "localhost";
    ObjectStorage server = new ObjectStorage_Proxy(new HorbURL(host, null));

    Data data = new Data();
    data.work();

    System.out.println("saving an object in a file, "+fname+" on server");
    // save the object
    server.saveObject(data, fname);

    System.out.println("object has saved. now load it again from server");

    // load the object
    Data data2 = (Data)server.loadObject(fname);
    data2.work();
  }
}
