package horb.examples.objectStorage;

import horb.orb.*;
import java.io.*;

class Client2 {

  public static void main(String argv[]) throws HORBException, IOException {

    String fname = "data.fof";

    String host = (argv.length == 1) ? argv[0] : "localhost";
    ObjectStorage server = new ObjectStorage_Proxy(new HorbURL(host, "ObjectStorage"));

    System.out.println("Aquiring the lock of "+fname);
    System.out.println(server.lock(fname, 0));

    System.out.println("Got lock. You may start another Client2 while I'm sleeping for 5 seconds.");
    try {
      Thread.sleep(5*1000);
    } catch (Exception e) {}

    // load the object
    Data data = (Data)server.loadObject("data.fof");
    System.out.println("Object has been loaded.");

    data.work();

    System.out.println("Saving the object in "+fname+" on server.");
    server.saveObject(data, fname);

    server.unlock(fname);
    System.out.println(fname+" unlocked.");
  }
}
