package horb.examples.persistent;

import horb.orb.*;
import java.io.*;

class Client {

  public static void main(String argv[]) throws HORBException, IOException {

    String host = (argv.length == 1) ? argv[0] : "localhost";
    Server_Proxy server = new Server_Proxy(new HorbURL(host, null));

    Data data = new Data();
    data.work();

    System.out.println("saving an object in a file, data.fof on server");
    // save the object
    server.saveObject(data, "data.fof");

    System.out.println("object has saved. now load it again from server");

    // load the object
    Data data2 = (Data)server.loadObject("data.fof");
    data2.work();
  }
}
