package horb.examples.wclock;

import java.awt.*;
import java.net.*;
import horb.orb.*;
import horb.examples.wclock.*;

public class WClock extends java.applet.Applet implements Runnable {
  boolean die;
  String host;
  Server_Proxy remoteServer;
  Server localServer;
  Thread kicker = null;
  int sleep;
  String errMsg = null;

  public void init() {
    die = false;
    resize(300,150);
    setFont(new Font("TimesRoman",Font.BOLD,48));
  }

  public void start() {
    die = false;
    if (kicker != null)
      return;
    try {
      host = getDocumentBase().getHost();
    } catch (Exception e0) {}
    if (host == null || host.length() == 0)
      host = "localhost";

    localServer = new Server(); // create local time server
    sleep = 1;
    kicker = new Thread(this);
    kicker.start();
  }

  public void paint(Graphics g) {
    // get current local time and display it
    String localTime = localServer.currentTime();
    g.setColor(Color.blue);
    g.drawString(localTime, 40, 100);

    // get remote time and display it
    if (remoteServer == null) {
      try {
	showStatus("creating object on "+host+"...");
	remoteServer = new Server_Proxy(new HorbURL(host, null));
	showStatus("calling server object on "+host);
	sleep = 1;
      } catch (Exception e) {
	showStatus("Connect failed. Firewall? DNS? or server down?");
	System.out.println(e);
	sleep = 10;
      }
    }
    if (remoteServer != null) {
      try {
	String remoteTime = remoteServer.currentTime();
	g.setColor(Color.red);
	g.drawString(remoteTime, 40, 60);
      } catch (Exception e) {
	remoteServer = null;
      }
    }
  }

  public void run() {
    while (die == false) {
      repaint();
      try {
	Thread.sleep(sleep*1000);
      } catch (InterruptedException e) {
	break;
      }
    }
  }

  public void stop() {
    die = true;
    if (kicker != null) {
      kicker.stop();
      kicker = null;
      if (remoteServer != null) {
	remoteServer._release();
	remoteServer = null;
      }
    }
  }
}
    
