/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribute this software and
 * for non-commercial purposes and without fee is hereby granted provided
 * this copyright notice.
 *
 */
package horb.examples.worldClock;

import horb.orb.*;
import java.net.*;
import java.io.*;

public class Client {
  Server_Proxy remoteServer;			// remote object reference
  String host;
  TimeObj local;

  public static void main(String argv[]) throws Exception {
    Client client = new Client(argv);
    client.run();
  }

  Client() {}

  Client(String argv[]) throws Exception {
    host = (argv.length == 1) ? argv[0] : "-";
    local = new TimeObj();
  }

  private void run() throws Exception {
    while (true) {
      try {
	remoteServer = new Server_Proxy(new HorbURL(host, null));
	while (true) {
	  local.setTime();
	  TimeObj[] global = remoteServer.getTime(local);
	  Thread.sleep(1000);
//	  for (int i = 0; i < global.length; i++)
//	    System.out.println(global[i].time + " " + global[i].whoAmI);
	}
      } catch (HORBException e) {
	System.err.println(e);
      }
      Thread.sleep(3000);
    }
  }
}
