package horb.examples.worldClock;
import horb.orb.*;
import java.util.*;

class Server {
  private String clientName;
  private static Hashtable global = new Hashtable();

  /** check in. */
  public Server() {
    try {
      clientName = HORBServer.getClientHostName();
    } catch (Exception e) {}
  }

  /** This method is remotely called every second. */
  public synchronized TimeObj[] getTime(TimeObj obj) {
    obj.whoAmI = clientName;
    global.put(obj.whoAmI, obj);

    // copy hashtable into an array to carry
    int num = (global.size() > 20) ? 20 : global.size();
    TimeObj[] times = new TimeObj[num];
    Enumeration e = global.elements();
    for (int i = 0; i < num && e.hasMoreElements(); i++) {
      times[i] = (TimeObj)e.nextElement();
    }
    return times;
  }

  /** check out. */
  public synchronized void _threadEndHook() {
    global.remove(clientName);
  }
}
