package horb.examples.worldClock;

import java.awt.*;
import java.net.*;
import horb.orb.*;
import java.applet.*;

public class WorldClock extends Applet implements Runnable {
  String host;
  Server_Proxy remoteServer;			// remote object reference
  boolean die;
  Thread kicker;
  int sleep;
  String errMsg;
  Font large = new Font("Helvetica",Font.PLAIN,28);
  Font small = new Font("TimesRoman",Font.ITALIC,12);
  int x = 500;
  int y = 300;

  public void init() {
    die = false;
    resize(x+40 ,y);				// show frame
    setBackground(new Color(220, 220, 255));
  }

  public void start() {
    die = false;
    if (kicker != null)
      return;
    try {
      host = getDocumentBase().getHost(); 	// get server hostname
    } catch (Exception e0) {}
    if (host == null || host.length() == 0)
      host = "localhost";

    sleep = 1;
    kicker = new Thread(this);			// start a timer thread
    kicker.start();
  }

  public void update(Graphics g) {
    paint(g);
  }

  public void paint(Graphics g) {
    if (remoteServer == null) {
      // create remote server object
      try {
	showStatus("creating object on "+host+"...");
	remoteServer = new Server_Proxy(new HorbURL(host, null));
	showStatus("calling server object on "+host);
	sleep = 1;
      } catch (Exception e) {
	showStatus("Connect failed. Firewall? DNS? or server down?");
	System.out.println(e);
	sleep = 10;
      }
    }
    if (remoteServer != null) {
      try {
	// pass local time to server and receive times
	TimeObj local = new TimeObj();
	local.setTime();
	TimeObj[] global = remoteServer.getTime(local); // call server
	for (int i = 0; i < 20; i++) {			// display times
	  g.clearRect(20+(i%4)*(x/4), (i/4)*(y/5), x/4, y/5);
	  if (i < global.length) {
	    g.setFont(large);
	    g.setColor(Color.blue);
	    g.drawString(global[i].time, 20+(i%4)*(x/4), 30+(i/4)*(y/5));
	    g.setFont(small); 
	    g.setColor(Color.red);
	    String s = global[i].whoAmI.toLowerCase();
	    int beg = s.length()-22;
	    s = s.substring((beg < 0 ? 0 : beg), s.length());
	    g.drawString(s, 20+(i%4)*(x/4), 50+(i/4)*(y/5));
	  }
	}
      } catch (Exception e) {
	remoteServer = null;
      }
    }
  }

  public void run() {
    while (die == false) {
      repaint();				// repaint each 1 sec
      try {
	Thread.sleep(sleep*1000);
      } catch (InterruptedException e) {
	break;
      }
    }
  }

  public void stop() {
    die = true;
    if (kicker != null) {
      kicker.stop();
      kicker = null;
      if (remoteServer != null) {
	remoteServer._release();
	remoteServer = null;
      }
    }
  }
}
    
