/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.tools.fofrun;

import horb.orb.*;
import java.io.*;
import horb.tools.util.*;

public class fofrun {
  static short major_version = 1;
  static short minor_version = 2;
  
  String foffile;
  String newFoffile;
  boolean autosave;
  boolean fofinfo;

  public static void main(String argv[]) throws Exception {
    fofrun o = new fofrun(argv);
    try {
      o.run();
    } catch (Exception e) {
      throw e;
    }
    System.exit(0);
  }

  public fofrun(String foffile, boolean autosave, String newFoffile) {
    this.foffile = foffile;
    this.autosave = autosave;
    this.newFoffile = newFoffile;
  }

  public fofrun(String argv[]) {
    parseCommandLine(argv);
  }

  public void run() throws HORBException, IOException, Exception {
    HorbURL url = null;
    HorbURL newurl = null;
    Restartable object = null;

    if (foffile.startsWith("file:") || foffile.startsWith("horb:"))
      url = new HorbURL(foffile);
    else
      url = new HorbURL("file:///"+foffile);
    
    if (autosave) {
      if (newFoffile == null)
	newFoffile = foffile;
      if (newFoffile.startsWith("file:") || newFoffile.startsWith("horb:"))
	newurl = new HorbURL(newFoffile);
      else
	newurl = new HorbURL("file:///"+newFoffile);
    }

    // recover a frozen object file
    FileIOCI file = new FileIOCI(url);

    if (fofinfo) {
      showFofinfo(file);
      System.exit(0);
    }

    try {
      object = (Restartable)file.load();
    } catch (IOException e) {
      System.err.println("Can't load "+url);
      throw e;
    } catch (Exception e) {
      System.err.println("Exception during loading the object");
      throw e;
    }

    try {
      object.restart();
    } catch (Exception e) {
      System.err.println("Exception during execution of the object");
      throw e;
    }

    // the object is working here

    if (autosave) {
      FileIOCI newfile = new FileIOCI(newurl);
      try {
	object.shutdown();
      } catch (Exception e) {
	System.err.println("Exception during shuting down the object");
	throw e;
      }	
      try {
	newfile.save(object);
      } catch (IOException e) {
	System.err.println("Can't save "+url);
	throw e;
      } catch (Exception e) {
	System.err.println("Exception during saving the object");
	throw e;
      }
    }
  }

  public void showFofinfo(FileIOCI file) throws HORBException, IOException {
    FofInfo info = file.getFofInfo();
    info.list(System.out);
  }

  private void parseCommandLine(String argv[]) {
    for (int i = 0; i < argv.length; i++) {
      if (argv[i].equals("-h") || argv[i].equals("-?") || argv[i].equals("-help")) {
	usage();
	System.exit(0);
      } else if (argv[i].equals("-autosave")) {
	autosave = true;
	if ((i+1) < argv.length) {
	  i++;
	  if (argv[i].startsWith("-") == false)
	    newFoffile = argv[i];
	}
      } else if (argv[i].equals("-version")) {
	System.out.println("fofrun version "+major_version
			   +"."+minor_version);
	System.exit(0);
      } else if (argv[i].equals("-info")) {
	fofinfo = true;
      } else {
	foffile = argv[i];
      }
    }
    
    if (foffile == null) {
      usage();
      System.exit(1);
    }
  }

  private void usage() {
    System.err.println("usage: fofrun [options] foffile.fof");
    System.err.println("description: run a freezed object");
    System.err.println("options:");
    System.err.println("    -? -h -help show this message");
    System.err.println("    -autosave [file]  save the object after execution");
    System.err.println("    -info       just show info of foffile.fof");
    System.err.println("    -version    show version");
    System.err.println("example: fofrun -autosave foo.fof foo.fof");
  }
}
