/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.tools.horbstat;

import horb.orb.*;
import java.io.*;
import horb.tools.util.*;

/**
 * HORB management user interface (command line version).
 *
 */
class horbstat {
  static short major_version = 1;
  static short minor_version = 2;
  
  HORB horb;
  HORBAgent agent;

  HorbURL url;			// requested URL
  HorbURL server;		// URL of the remote HORB Server

  String host;
  int port;
  String objectID;
  String username;
  String passwd;
  int interval;

  boolean showServer;
  boolean showObject = true;
  boolean showThread;

  public static void main(String argv[]) throws HORBException, IOException {

    horbstat h = new horbstat();
    h.doit(argv);
  }

  void doit(String argv[]) {
    try {
      url = new HorbURL("horb://-/");
    } catch (Exception e0);
    parseCommandLine(argv);

    server = new HorbURL(url.getHost(), url.getPort(), null);
    if (host != null)
      server.setHost(host);
    if (port != 0)
      server.setPort(port);
    if (objectID == null)
      objectID = url.getObjectID();

    try {
      horb = new HORB();
      agent = new HORBAgent_Proxy(server, username, passwd);
      ((HORBAgent_Proxy)agent).HORBAgent_Impl();
    } catch (Exception e2) {
      System.err.println("Can't connect to HORB server.");
      System.err.println(e2);
      System.exit(1);
    }

    if (interval > 0) {
      while (true) {
	try {
	  display();
//	  Thread.sleep(1000*interval);
	} catch (Exception e1) {
	  System.exit(0);
	}
      }      
    } else
	try {
	  display();
	} catch (Exception e1) {
	  System.exit(0);
	}
  }
  
  void display() throws HORBException, IOException {
    if (showServer)
      putAllServerStatus();
    if (showObject)
      putAllObjectStatus();
    if (!showObject && showThread)
      putAllThreadStatus(null);
  }

  void putAllServerStatus() throws HORBException, IOException {
    if (port != 0) {
      ServerStatus ss = agent.getServerStatus(port);
      putServerStatus(ss);
    } else {
      ServerStatus[] ss = agent.getServerStatus();
      if (ss != null)
	for (int i = 0; i < ss.length; i++)
	  putServerStatus(ss[i]);
    }
  }


  void putServerStatus(ServerStatus ss) {
    if (ss == null)
      return;

    System.out.println("Server Status");
    ss.list(System.out);
    System.out.println();
  }

  void putAllObjectStatus() throws HORBException, IOException {
    if (objectID != null) {
      ObjectStatus os = agent.getObjectStatus(objectID);
      putObjectStatus(os);
      if (showThread)
	putAllThreadStatus(objectID);
    } else {
      ObjectStatus[] os = agent.getObjectStatus();
      if (os != null)
	for (int i = 0; i < os.length; i++) {
	  putObjectStatus(os[i]);
	  if (showThread)
	    putAllThreadStatus(os[i].objectID);
	}
    }
  }

  void putObjectStatus(ObjectStatus os) {
    if (os == null)
      return;
    System.out.println("Object Status");
    os.list(System.out);
    System.out.println();
  }

  void putAllThreadStatus(String objectID) throws HORBException, IOException {
    ThreadStatus[] ts;
    if (objectID != null)
      ts = agent.getThreadStatus(objectID);
    else
      ts = agent.getThreadStatus();
    if (ts != null)
      for (int i = 0; i < ts.length; i++)
	putThreadStatus(ts[i]);
  }

  void putThreadStatus(ThreadStatus ts) {
    if (ts == null)
      return;
    System.out.println("\tThread Status");
    ts.list(System.out);
    System.out.println();
  }

  private void parseCommandLine(String argv[]) {
    //
    // parse command line
    //
    for (int i = 0; i < argv.length; i++) {
      if (argv[i].equals("-h") || argv[i].equals("-?") || argv[i].equals("-help")) {
	usage();
	System.exit(0);
      } else if (argv[i].equals("-server")) {
	showServer = true;
	showObject = false;
      } else if (argv[i].equals("-t") || argv[i].equals("-thread")) {
	showThread = true;
      } else if (argv[i].equals("-o") || argv[i].equals("-object")) {
	if ((i+1) < argv.length) {
	  i++;
	  objectID = argv[i];
	} else {
	  System.err.println("-object objectID");
	  System.exit(1);
	}
      } else if (argv[i].equals("-h") || argv[i].equals("-host")) {
	if ((i+1) < argv.length) {
	  i++;
	  host = argv[i];
	} else {
	  System.err.println("-host hostname");
	  System.exit(1);
	}
      } else if (argv[i].equals("-p") || argv[i].equals("-port")) {
	if ((i+1) < argv.length) {
	  i++;
	  port = Integer.parseInt(argv[i]);
	} else {
	  System.err.println("-port requires port number as -port num");
	  System.exit(1);
	}
      } else if (argv[i].equals("-s")) {
	if ((i+1) < argv.length) {
	  i++;
	  interval = Integer.parseInt(argv[i]);
	} else {
	  System.err.println("-s interval_seconds");
	  System.exit(1);
	}
      } else if (argv[i].equals("-user")) {
	if ((i+1) < argv.length) {
	  i++;
	  username = argv[i];
	} else {
	  System.err.println("-user username");
	  System.exit(1);
	}
      } else if (argv[i].equals("-passwd")) {
	if ((i+1) < argv.length) {
	  i++;
	  passwd = argv[i];
	} else {
	  System.err.println("-passwd password");
	  System.exit(1);
	}
      } else if (argv[i].equals("-version")) {
	System.out.println("horbstat version "+major_version
			   +"."+minor_version);
	System.exit(0);
      } else if (argv[i].startsWith("-")) {
	System.err.println("invalid flag: " + argv[i]);
	System.exit(1);
      } else {
	try {
	  url = new HorbURL(argv[i]);
	} catch (Exception e) {
	  System.err.println("Invalid URL: "+e);
	}
      }
    }
  }

  void usage() {
    System.err.println("usage: horbstat [options] [URL]");
    System.err.println("options:");
    System.err.println("    -? -h -help   show this message");
    System.err.println("    -version      show version");
    System.err.println("    -host <hostname>   connect to hostname");
    System.err.println("    -port <num>   connect to port <num>");
    System.err.println("    -server       show server statistics");
    System.err.println("    -t -thread    show thread statistics");
    System.err.println("    -o <objectID> object only");
    System.err.println("    -s <num>      show each <num> seconds");
    System.err.println("    -user <name>  connect as <name>");
    System.err.println("    -passwd <passwd> password of user");
  }
}
