/*
 * $Header$
 *
 * Copyright (C) 1995, 1996 HIRANO Satoshi
 *
 * Permission to use, copy, modify and redistribution this software in
 * whole and in part, for evaluation or research purposes and without fee
 * is hereby granted provided this copyright notice.
 * See CopyrightAndLicensing.txt for licensing condition.
 */


package horb.tools.util;

import java.util.Date;

/**
 * Formated Date
 *
 */
public class FormatDate extends Date {
  /**
   * initialize date with current date and time.
   */
  public FormatDate() {}

  /**
   * initialize date with time.
   */
  public FormatDate(long time) {
    super(time);
  }

  /**
   * return a string in format 1996/01/26 16:45:43
   */
  public String getYMDHMS() {
    return getYMD()+" "+getHMS();
  }

  /**
   * return a string in format 01/26 16:45:43
   */
  public String getMDHMS() {
    return getMD()+" "+getHMS();
  }

  /**
   * return a string in format 01/26 16:45
   */
  public String getMDHM() {
    return getMD()+" "+getHM();
  }

  /**
   * return a string in format 1996/01/26
   */
  public String getYMD() {
    int year = getYear()+1900;
    int mon = getMonth()+1;
    int day = getDate();
    return ""+year+'/'+mon/10+mon%10+'/'+day/10+day%10;
  }

  /**
   * return a string in format 01/26
   */
  public String getMD() {
    int mon = getMonth()+1;
    int day = getDate();
    return ""+mon/10+mon%10+'/'+day/10+day%10;
  }

  /**
   * return a string in format 16:45:43
   */
  public String getHMS() {
    int hour = getHours();
    int min = getMinutes();
    int sec = getSeconds();
    return ""+ hour/10 + hour%10 + ":" + min/10+min%10+ ":" + sec/10 + sec%10;
  }

  /**
   * return a string in format 16:45
   */
  public String getHM() {
    int min = getMinutes();
    int sec = getSeconds();
    return ""+ min/10 + min%10 + ":" + sec/10 + sec%10;
  }

}
