/**
 * wrapper.java - Java application wrapper for NanoCAD applet
 * Copyright (c) 1997 Will Ware, all rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    or its derived works must display the following acknowledgement:
 * 	This product includes software developed by Will Ware.
 * 
 * This software is provided "as is" and any express or implied warranties,
 * including, but not limited to, the implied warranties of merchantability
 * or fitness for any particular purpose are disclaimed. In no event shall
 * Will Ware be liable for any direct, indirect, incidental, special,
 * exemplary, or consequential damages (including, but not limited to,
 * procurement of substitute goods or services; loss of use, data, or
 * profits; or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort (including
 * negligence or otherwise) arising in any way out of the use of this
 * software, even if advised of the possibility of such damage.
 */

import java.awt.*;
import nanocad;

public class wrapper extends Frame
{
  public static final String rcsid =
  "$Id: wrapper.java,v 1.8 1997/08/12 04:22:56 wware Exp $";
  public static nanocad nc;
  public Menu menu;
  public static MenuBar menubar;
  public wrapper ()
  {
    this.setTitle ("NanoCAD Java Prototype");
    this.resize (600, 550);
    
    nc = new nanocad();
    this.add ("Center", nc);
    nc.init ();
    
    menu = new Menu ("File");
    menubar = new MenuBar ();
    menu.add ("Load");
    menu.add ("Save");
    menu.add ("Quit");
    menubar.add (menu);
    this.setMenuBar (menubar);
  }
  public boolean handleEvent (Event e, Object arg)
  {
    if (e.id == Event.WINDOW_DESTROY)
      {
	// for some reason, we never seem to get here
	System.exit (0);
	return true;
      }
    return false;
  }
  public boolean action (Event e, Object arg)
  {
    FileDialog fd;
    if (e.arg == "Load")
      {
	fd = new FileDialog (this,
			     "File to Load",
			     FileDialog.LOAD);
	fd.show ();
	return true;
      }
    else if (e.arg == "Save")
      {
	fd = new FileDialog (this,
			     "File to Save",
			     FileDialog.SAVE);
	fd.show ();
	return true;
      }
    else if (e.arg == "Quit")
      {
	System.exit (0);
	return true;
      }
    return false;
  }
  public static void main(String[] args)
  {
    wrapper w = new wrapper();
    w.show ();
  }
}
