/* $Id: gifd.c,v 1.1 1995/06/13 01:59:33 pturner Exp pturner $
 *
 * driver for GIF format
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include "externs.h"

#include "gd.h"
#include "gdfontl.h"
#include "gdfonts.h"

extern double charsize;
extern double devcharsize;
extern int ptofile;
extern char printstr[];
extern char *curprint;		/* curprint = gd_prstr */
extern int maxcolors;

/*
 * spool using these
 */
#ifndef GD_PRSTR
char gd_prstr[128] = "/bin/mv ";

#else
char gd_prstr[128] = GD_PRSTR1;

#endif

static char tmpbuf[64];

#define GDXMIN 0
#define GDXMAX 640
#define GDYMIN 0
#define GDYMAX 480
#define DXGD 640
#define DYGD 480

#define MINCOLOR 0
#define MAXCOLOR 16
#define MAXLINEWIDTH 1
#define MAXLINESTYLE 14

static int gdxmin = GDXMIN;
static int gdxmax = GDXMAX;
static int gdymin = GDYMIN;
static int gdymax = GDYMAX;
static int gddx = DXGD;
static int gddy = DYGD;

static int gdcolor;
static int gddmode;
static int gdfont = 0;
static double gdcharsize = 0.5;
static int gdlinestyle;
static int gdfillpat = 0;

static int gdcolors[256];

double xconv(double x), yconv(double y);

static FILE *gdout;

static char *fname;

static int orientflag = 0;

static gdImagePtr im_in, im_out;

void cgif(int x, int y)
{
    if (x < 0 || y < 0 || x >= gdxmax || y >= gdxmax) {
printf("out of bounds %d %d\n", x, y);
    }
}

int gdsetmode(int mode)
{
    int i;
    static char tbuf[128];
    static int first = 1;
    char sysbuf[128];
    char *mktemp(char *);


    if (mode % 2) {
	if (!ptofile) {
	    strcpy(tbuf, "xmgrXXXXXX");
	    fname = mktemp(tbuf);
	} else {
	    fname = printstr;
	}
        im_out = gdImageCreate(gddx, gddy);
    }
    for (i=0;i<maxcolors;i++) {
	gdcolors[i] = gdImageColorAllocate(im_out, red[i], green[i], blue[i]);
    }
    switch (mode) {
    case 3:			/* GD portrait */
	orientflag = 1;
    case 1:			/* GD landscape */
	gddx = gdxmax;
	gddy = gdymax;
	break;
    case 2:			/* */
    case 4:			/* */
/*
        gdImageInterlace(im_out, 1);
*/
        gdout = fopen(fname, "wb");
        gdImageGif(im_out, gdout);
	fclose(gdout);
	gdImageDestroy(im_out);

	if (!ptofile) {
/*
	    sprintf(sysbuf, "/bin/mv %s out.gif", fname);
	    system(sysbuf);
*/
	}
	orientflag = 0;
	break;
    }
    return 1;
}

static int x1 = 99999, y1 = 99999;

void drawgd(int x2, int y2, int mode)
{

	if (mode) {
cgif(x1, gdymax - y1);
cgif(x2, gdymax - y2);
	    gdImageLine(im_out, x1, gdymax - y1, x2, gdymax - y2, gdcolors[gdcolor]);
	} else {
	    if (!(x1 == x2 && y1 == y2)) {
	    }
	}
	x1 = x2;
	y1 = y2;
}

int xconvgd(double x)
{
    if (orientflag) {
	return ((int) (gddy * xconv(x)));
    } else {
	return ((int) (gddx * xconv(x)));
    }
}

int yconvgd(double y)
{
    if (orientflag) {
	return ((int) (gddx * yconv(y)));
    } else {
	return ((int) (gddy * yconv(y)));
    }
}

void gdsetfont(int n)
{
    hselectfont(gdfont = n);
}

int gdsetcolor(int c)
{
    if (c) {
	c = (c - 1) % MAXCOLOR + 1;
    }
    gdcolor = c;
    return c;
}

/* only one line width */
int gdsetlinewidth(int c)
{
    return c;
}

void gddrawtic(int x, int y, int dir, int updown)
{
    switch (dir) {
	case 0:
	switch (updown) {
	    case 0:
	    drawgd(x, y, 0);
	    drawgd(x, y + devxticl, 1);
	    break;
	case 1:
	    drawgd(x, y, 0);
	    drawgd(x, y - devxticl, 1);
	    break;
	}
	break;
    case 1:
	switch (updown) {
	case 0:
	    drawgd(x, y, 0);
	    drawgd(x + devyticl, y, 1);
	    break;
	case 1:
	    drawgd(x, y, 0);
	    drawgd(x - devyticl, y, 1);
	    break;
	}
	break;
    }
}

int gdsetlinestyle(int style)
{
    char stmp[20];

    switch (style) {
    case 1:
	break;
    case 2:
	break;
    case 3:
	break;
    case 4:
	break;
    case 5:
	break;
    case 6:
	break;
    case 7:
	break;
    case 8:
	break;
    default:
	break;
    }
    return (gdlinestyle = style);
}

void dispstrgd(int x, int y, int rot, char *s, int just, int fudge)
{
    puthersh(x, y, gdcharsize * charsize, rot, just, gdcolor, drawgd, s);
}

int gdsetpat(int pat)
{
    return (gdfillpat = pat % 7);
}

int setpatgd(int pat)
{
    switch (pat) {
    case 0:
	return (0);
    case 1:
	break;
    case 2:
	break;
    case 3:
	break;
    case 4:
	break;
    case 5:
	break;
    case 6:
	break;
    default:
	return (0);
    }
    return (pat);
}

void gdfill(int n, int *px, int *py)
{
    if (n < 3) {
	return;
    }
}

void gdfillcolor(int n, int *px, int *py)
{
    int i, x, y;
    gdPoint *p;
    if (n < 3) {
	return;
    }
    p = (gdPoint *) calloc(n, sizeof(gdPoint));
    if (p == NULL) {
        return;
    }
    for (i = 0; i < n; i++) {
        p[i].x = px[i];
        p[i].y = gdymax - py[i];
cgif(p[i].x, p[i].y);
    }
    gdImageFilledPolygon(im_out, p, n, gdcolor);
    cfree(p);
}

void gdleavegraphics(void)
{
    gdsetmode(gddmode + 1);
}

void gddrawarc(int x, int y, int r)
{
    gdImageArc(im_out, x, gdymax - y, 2 * r, 2 * r, 0, 360, gdcolor);
}

void gdfillarc(int x, int y, int r)
{
    gdImageArc(im_out, x, gdymax - y, 2 * r, 2 * r, 0, 360, gdcolor);
}

void gddrawellipse(int x, int y, int xm, int ym)
{
    gdImageArc(im_out, x, gdymax - y, xm, ym, 0, 360, gdcolor);
}

void gdfillellipse(int x, int y, int xm, int ym)
{
    gdImageArc(im_out, x, gdymax - y, xm, ym, 0, 360, gdcolor);
}

int gdinitgraphics(int dmode)
{
    gddmode = dmode;
    if (!gdsetmode(gddmode)) {
	return -1;
    }
    devconvx = xconvgd;
    devconvy = yconvgd;
    vector = drawgd;
    devwritestr = dispstrgd;
    devsetcolor = gdsetcolor;
    devsetfont = gdsetfont;
    devsetline = gdsetlinestyle;
    devsetlinew = gdsetlinewidth;
    devdrawtic = gddrawtic;
    devsetpat = gdsetpat;
    devfill = gdfill;
    devdrawarc = gddrawarc;
    devfillarc = gdfillarc;
    devfillcolor = gdfillcolor;
    devdrawellipse = gddrawellipse;
    devfillellipse = gdfillellipse;
    devleavegraphics = gdleavegraphics;
    devcharsize = gdcharsize;
    devsymsize = 5;
    devxticl = 10;
    devyticl = 10;
    devarrowlength = 15;
    setfont(2);
    setcolor(1);
    setlinestyle(0);
    return 0;
}
