/* $Id: printwin.c,v 1.2 1995/05/20 04:06:05 pturner Exp pturner $
 *
 * Printer initialization
 */

#include <stdio.h>

#include <Xm/Xm.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>

#include "globals.h"
#include "protos.h"
#include "motifinc.h"

extern int ptofile;
extern int epsflag;		/* declared in ps.c */
extern int ps2flag;		/* declared in ps.c */

char *cursuffix;
#ifndef EPS_SUFFIX
char eps_suffix[MAX_BUF_LEN] = ".eps";
#else
char eps_suffix[MAX_BUF_LEN] = EPS_SUFFIX;
#endif

static Widget *printto_item;	/* for printer select popup */
static Widget printstring_item;
static Widget psetup_frame;
static Widget psetup_panel;
static Widget *devices_item;
static Widget eps_item;
static Widget eps_string;
static Widget ps2_item;
static Widget ps2_string;
static Widget buts[5];

static void do_pr_toggle(Widget w, XtPointer client_data, XtPointer call_data);
static void set_printer_proc(Widget w, XtPointer client_data, XtPointer call_data);
static void do_print(Widget w, XtPointer client_data, XtPointer call_data);
void create_printfiles_popup(Widget, XtPointer, XtPointer call_data);
void do_eps_toggle(Widget, XtPointer, XtPointer call_data);

void create_printer_setup(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget rc, rc_eps, rc_ps2;
    int i, x, y;
    set_wait_cursor();
    if (psetup_frame == NULL) {
	char *label1[5];
	label1[0] = "Accept (no print)";
	label1[1] = "Print";
	label1[2] = "File...";
	label1[3] = "Cancel";
	label1[4] = "Help";
	XmGetPos(app_shell, 0, &x, &y);
	psetup_frame = XmCreateDialogShell(app_shell, "Printer setup", NULL, 0);
	handle_close(psetup_frame);
	XtVaSetValues(psetup_frame, XmNx, x, XmNy, y, NULL);
	psetup_panel = XmCreateRowColumn(psetup_frame, "psetup_rc", NULL, 0);

	rc = XtVaCreateWidget("rc", xmRowColumnWidgetClass, psetup_panel,
			      XmNpacking, XmPACK_COLUMN,
			      XmNnumColumns, 4,
			      XmNorientation, XmHORIZONTAL,
			      XmNisAligned, True,
			      XmNadjustLast, False,
			      XmNentryAlignment, XmALIGNMENT_END,
			      NULL);

	XtVaCreateManagedWidget("Device: ", xmLabelWidgetClass, rc, NULL);
	devices_item = CreatePanelChoice(rc, " ",
					 9,
					 "PostScript landscape",
					 "PostScript portrait",
					 "FrameMaker landscape",
					 "FrameMaker portrait",
					 "HPGL landscape",
					 "HPGL portrait",
					 "Interleaf landscape",
					 "Interleaf portrait",
					 0, 0);
	for (i = 0; i < 8; i++) {
	    XtAddCallback(devices_item[2 + i], XmNactivateCallback,
			(XtCallbackProc) do_prstr_toggle, (XtPointer) i);
	}

	XtVaCreateManagedWidget("Print to: ", xmLabelWidgetClass, rc, NULL);
	printto_item = CreatePanelChoice(rc, " ",
					 3,
					 "Printer",
					 "File", 0, 0);
	for (i = 0; i < 2; i++) {
	    XtAddCallback(printto_item[2 + i], XmNactivateCallback,
			  (XtCallbackProc) do_pr_toggle, (XtPointer) i);
	}

	printstring_item = CreateTextItem4(rc, 30, "Print control string:");
	XtVaSetValues( printstring_item, XmNscrollHorizontal, True, NULL );

	rc_eps = XtVaCreateWidget("rc_eps", xmRowColumnWidgetClass, rc,
			      XmNorientation, XmHORIZONTAL,
			      XmNisAligned, True,
			      XmNadjustLast, False,
			      XmNentryAlignment, XmALIGNMENT_END,
			      NULL);
	
	eps_string = XtVaCreateManagedWidget("Generate EPS ", xmLabelWidgetClass, rc_eps, NULL);
	eps_item = XmCreateToggleButton(rc_eps, " ", NULL, 0);
	XtAddCallback(eps_item, XmNvalueChangedCallback, 
 				(XtCallbackProc) do_eps_toggle, NULL );
	XtManageChild(eps_item);
	XtManageChild(rc_eps);
	
	rc_ps2 = XtVaCreateWidget("rc_ps2", xmRowColumnWidgetClass, rc,
			      XmNorientation, XmHORIZONTAL,
			      XmNisAligned, True,
			      XmNadjustLast, False,
			      XmNentryAlignment, XmALIGNMENT_END,
			      NULL);
	ps2_string = XtVaCreateManagedWidget("Level 2 PS ", xmLabelWidgetClass, rc_ps2, NULL);
	ps2_item = XmCreateToggleButton(rc_ps2, " ", NULL, 0);
	XtManageChild(ps2_item);
	
	XtManageChild(rc_ps2);
	
	XtManageChild(rc);

	XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, psetup_panel, NULL);

	CreateCommandButtons(psetup_panel, 5, buts, label1);
	XtAddCallback(buts[0], XmNactivateCallback,
		    (XtCallbackProc) set_printer_proc, (XtPointer) NULL);
	XtAddCallback(buts[1], XmNactivateCallback,
		      (XtCallbackProc) do_print, (XtPointer) NULL);
	XtAddCallback(buts[2], XmNactivateCallback,
		    (XtCallbackProc) create_printfiles_popup, (XtPointer) NULL);
	XtAddCallback(buts[3], XmNactivateCallback,
	      (XtCallbackProc) destroy_dialog, (XtPointer) psetup_frame);
	XtAddCallback(buts[4], XmNactivateCallback,
	      (XtCallbackProc) HelpCB, (XtPointer) HELP_FILE_PRINT_SETUP);
	XtManageChild(psetup_panel);
    }
    XtRaise(psetup_frame);
    do_pr_toggle(NULL, (XtPointer)ptofile, NULL );
    update_printer_setup();
    unset_wait_cursor();
}

void update_printer_setup(void)
{
    if (psetup_frame) {
	SetChoice(devices_item, hdevice - 1);
	SetChoice(printto_item, ptofile);
/*
 * 	XmToggleButtonSetState(eps_item, epsflag, False);
 */ 
	XmToggleButtonSetState(ps2_item, ps2flag, False);
	if (hdevice != 1 && hdevice != 2) {
	    XtSetSensitive(eps_item, False);
	    XtSetSensitive(eps_string, False);
	    XtSetSensitive(ps2_item, False);
	    XtSetSensitive(ps2_string, False);
	} else {
	    XtSetSensitive(eps_item, True);
	    XtSetSensitive(eps_string, True);
	    XtSetSensitive(ps2_item, True);
	    XtSetSensitive(ps2_string, True);
	}
	if (ptofile) {
	    xv_setstr(printstring_item, printstr);
	} else {
	    xv_setstr(printstring_item, curprint);
	}
    }
}

static void set_printer_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    char tmpstr[128];
    hdevice = (int) GetChoice(devices_item) + 1;
    ptofile = (int) GetChoice(printto_item);
    epsflag = XmToggleButtonGetState(eps_item);
    ps2flag = XmToggleButtonGetState(ps2_item);
    strcpy(tmpstr, (char *) xv_getstr(printstring_item));
    if (ptofile) {
	strcpy(printstr, tmpstr);
    } else {
	strcpy(curprint, tmpstr);
    }
    XtUnmanageChild(psetup_frame);
}


void do_eps_toggle(Widget w, XtPointer client_data, XtPointer call_data)
{
    epsflag = XmToggleButtonGetState(eps_item);
	strcpy(buf, (char *) xv_getstr(printstring_item));
	if( epsflag ){
		cursuffix = eps_suffix;
		change_suffix( buf, eps_suffix );
	} else {
		cursuffix = ps_suffix;
		change_suffix( buf, ps_suffix );
	}
	xv_setstr(printstring_item, buf);
    XtVaSetValues(printstring_item , XmNcursorPosition, strlen(buf), NULL );
}

/*
 * Print button
 */
static void do_print(Widget w, XtPointer client_data, XtPointer call_data)
{
    set_wait_cursor();
    set_printer_proc(NULL, NULL, NULL);
    do_hardcopy();
    unset_wait_cursor();
}

/*
 * set the print options
 */
void do_prstr_toggle(Widget w, XtPointer client_data, XtPointer call_data)
{
    int value = (int) client_data;
 
    set_printer(value + 1, NULL);
    if ((int) GetChoice(printto_item) == 0) {
		xv_setstr(printstring_item, curprint);
    }else {
		strcpy(buf, (char *) xv_getstr(printstring_item));
    	change_suffix( buf, cursuffix );
		xv_setstr(printstring_item, buf);
    	XtVaSetValues(printstring_item , XmNcursorPosition, strlen(buf), NULL );
	}
	if (hdevice != 1 && hdevice != 2){
		epsflag = False;
		XmToggleButtonSetState(eps_item, epsflag, False);
	}
}

static void do_pr_toggle(Widget w, XtPointer client_data, XtPointer call_data)
{
    int value = (int) client_data;
    int i;
    char *base;
    
    ptofile = (int) GetChoice(printto_item);
    if (value) {
   	/* strip suffix from docname and use that as default file name */
   	base = strdup( mybasename( docname ) ); 
   	i = strlen( base );
   	do{ 
   		i--;
   	}while( i>=0 && base[i] != '.' );
    	strcpy( printstr, base );
   	if( i>0 )
    		printstr[i]='\0';
    	strcat( printstr, cursuffix );
	xv_setstr(printstring_item, printstr);
	XtSetSensitive(buts[2], True);
    } else {
	xv_setstr(printstring_item, curprint);
	XtSetSensitive(buts[2], False);
    }
}

static void do_prfilesel_proc(Widget w, XtPointer client_data, 
														XtPointer call_data)
{
    Widget dialog = (Widget) client_data;
    char *s;
    XmFileSelectionBoxCallbackStruct *cbs =
        (XmFileSelectionBoxCallbackStruct *) call_data;

	if (!XmStringGetLtoR(cbs->value, charset, &s)) {
        errwin("do_prfilesel_proc(): Error converting XmString to char string");
        return;
    }
    xv_setstr(printstring_item, s);
    strcpy( printstr, s );
    XtVaSetValues(printstring_item , XmNcursorPosition, strlen(s), NULL );
    XtFree(s);
    XtUnmanageChild(dialog);
}


void create_printfiles_popup(Widget w, XtPointer client_data, XtPointer call_data)
{
    static Widget top;

    if( !GetChoice(printto_item) ) { 
	return;     	/* return if print to printer */
    } else {
    	set_wait_cursor();
    	if (top == NULL) {
	    top = XmCreateFileSelectionDialog(app_shell, "prfilsel", NULL, 0);
	    XtVaSetValues(XtParent(top), XmNtitle, "Select print file", NULL);
	    XtAddCallback(top, XmNokCallback, (XtCallbackProc) do_prfilesel_proc,
        							(XtPointer) top);
     	    XtAddCallback(top, XmNcancelCallback, (XtCallbackProc) destroy_dialog,
        							(XtPointer) top);
    	}
	    XtVaSetValues(top, XmNdirMask,  XmStringConcat(
				    XmStringCreate( "*", charset),
				    XmStringCreate( cursuffix, charset) ), NULL );
    	XtRaise(top);
    	unset_wait_cursor();
    }
}
