
#####################################################
#        Makefile for XMGR4 (VMS)    Ver. 1.5       #
#####################################################

# Rolf Niepraschk, 3/97, niepraschk@ptb.de

.IFDEF SCNDCALL  !-------------- second call ------------

TOP = [-]
VMSDIR = [.VMS]

.INCLUDE $(TOP)MAKE.CONF 
X11_MIT = $(VMSDIR)

CF = /G_FLOAT

.IFDEF USE_DEBUG
DB1 = /DEBUG
DB2 = /NOOPTI
.ELSE
DB2 = /NOWARN
.ENDIF	

D0 = MOTIF=1
I0 = $(VMSDIR)    

.IFDEF USE_XBAE
D1 = ,HAS_XBAE=1
I1 = ,$(XBAE_INCLUDES)
.ENDIF

.IFDEF USE_NETCDF
D2 = ,HAVE_NETCDF=1
I2 = ,$(NETCDFINCLUDES)
.ENDIF	

.IFDEF USE_MFHDF
D3 = ,HAVE_MFHD=1
I3 = ,$(MFHDFINCLUDES)
.ENDIF	

.IFDEF USE_DRAGnDROP
D4 = ,DRAGnDROP=1
.ENDIF

.IFDEF HC_ORIENTATION_P
HC_ORIENTATION_FLAG = P
.ELSE
HC_ORIENTATION_FLAG = L
.ENDIF

.IFDEF MIF
D5 = ,MIF_PRSTR=""$(MIF_PRSTR)"",HDEV=GR_MIF_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF HPGL
D5 = ,HPGL_PRSTR=""$(HP_PRSTR)"",HDEV=GR_HPGL_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF LEAF
D5 = ,LEAF_PRSTR=""$(LEAF_PRSTR)"",HDEV=GR_LEAF_$(HC_ORIENTATION_FLAG)
.ENDIF
.IFDEF PS
D5 = ,PS_PRSTR=""$(PS_PRSTR)"",HDEV=GR_PS_$(HC_ORIENTATION_FLAG)
.ENDIF

#D6 = ,$(MAXDIST)

D7 = ,GR_HOME="""$(XMGRDIR)""",GR_HELPVIEWER="""$(HELPVIEWER)"""

.IFDEF USE_LIBHELP
D8 = ,LIBHELP=1
.ENDIF

D9 = ,"lines=lines_"

MISCLIBS = ,$(VMSDIR)vms.opt/opt ,$(VMSDIR)'MOTIF_OPT'

CFLAGS = $(DB1)$(DB2)$(CF)\
/DEFINE=($(D0)$(D1)$(D2)$(D3)$(D4)$(D5)$(D6)$(D7)$(D8)$(D9))\
/INCL=($(I0)$(I1)$(I2)$(I3))

LFLAGS = $(DB1) 

SRCS =  main.c xmgr.c events.c malerts.c fileswin.c blockwin.c\
	eblockwin.c printwin.c drawwin.c comwin.c compwin.c\
	setwin.c hotwin.c ptswin.c editpwin.c regionwin.c\
	statuswin.c symwin.c tickwin.c graphwin.c worldwin.c\
	strwin.c labelwin.c locatewin.c framewin.c pagewin.c\
	monwin.c helpwin.c nonlwin.c miscwin.c \
	misc.c plotone.c files.c utils.c drawticks.c\
	lmdif1.c as274c.c fit.c fourier.c io.c\
	binio.c graphu1.c graphu2.c setutils.c setprops.c\
	regionutils.c objutils.c computils.c defaults.c checkon.c\
	params.c getparms.c compute.c xvlib.c rotated.c\
	image_f_io.c draw.c ps.c mif.c leaf.c\
	hp.c chersh.c pars.c motifutils.c psbb.c symfunc.c

OBJS =  main.obj xmgr.obj events.obj malerts.obj fileswin.obj blockwin.obj \
	eblockwin.obj printwin.obj drawwin.obj comwin.obj compwin.obj \
	setwin.obj hotwin.obj ptswin.obj editpwin.obj regionwin.obj \
	statuswin.obj symwin.obj tickwin.obj graphwin.obj worldwin.obj \
	strwin.obj labelwin.obj locatewin.obj framewin.obj pagewin.obj \
	monwin.obj helpwin.obj nonlwin.obj miscwin.obj \
	misc.obj plotone.obj files.obj utils.obj drawticks.obj \
	lmdif1.obj as274c.obj fit.obj fourier.obj io.obj \
	binio.obj graphu1.obj graphu2.obj setutils.obj setprops.obj \
	regionutils.obj objutils.obj computils.obj defaults.obj checkon.obj \
	params.obj getparms.obj compute.obj xvlib.obj rotated.obj \
	image_f_io.obj draw.obj ps.obj mif.obj leaf.obj \
	hp.obj chersh.obj pars.obj motifutils.obj psbb.obj symfunc.obj\
	missing_math.obj getpwnam.obj vms_unix.obj

.FIRST
	@ define X11 DECW$INCLUDE, $(X11_MIT)
	@ @sys$update:decw$get_image_version sys$share:decw$xlibshr.exe \
	  DECW$VERSION
	@ if f$locate("V1.2", DECW$Version) .ne. f$length(DECW$VERSION) \
	  then MOTIF_OPT == "motif1_2.opt/opt" 
	@ if f$locate("V1.1", DECW$Version) .ne. f$length(DECW$VERSION) \
	  then MOTIF_OPT == "motif1_1.opt/opt" 
			
DEFAULT : xmgr.exe
	@ !	
	
xmgr.exe : $(OBJS)
	link /exe=$@ $(LFLAGS) $+ $(MISCLIBS) 
	
missing_math.obj : $(VMSDIR)missing_math.c

vms_unix.obj : $(VMSDIR)vms_unix.c
	
getpwnam.obj : $(VMSDIR)getpwnam.c 
		
#
.ELSE	         !-------------- first call ------------

TOP = [-]
.INCLUDE $(TOP)MAKE.CONF 
	
DEFAULT :
	@ PARAM = "/MACRO=(SCNDCALL=1"
	@ PARAM1 = ""
	@ PARAM2 = ""
	@ PARAM3 = ""
	@ PARAM4 = ""
	@ PARAM5 = ""
	@ PARAM6 = ""
	@ PARAM7 = ""
	@ PARAM8 = ""
	@ IF F$EDIT("$(USE_DEBUG)","UPCASE") .EQS. "YES" THEN \
	  PARAM1 = ",USE_DEBUG=1"
	@ IF F$EDIT("$(USE_XBAE)","UPCASE") .EQS. "YES" THEN \
	  PARAM2 = ",USE_XBAE=1"
	@ IF F$EDIT("$(USE_NETCDF)","UPCASE") .EQS. "YES" THEN \
	  PARAM3 = ",USE_NETCDF=1"  
	@ IF F$EDIT("$(USE_MFHDF)","UPCASE") .EQS. "YES" THEN \
	  PARAM4 = ",USE_MFHDF=1" 
	@ IF F$EDIT("$(USE_DRAGnDROP)","UPCASE") .EQS. "YES" THEN \
	  PARAM5 = ",USE_DRAGnDROP=1" 
	@ IF F$EDIT("$(HC_ORIENTATION)","UPCASE") .EQS. "PORTRAIT" THEN \
	  PARAM6 = ",HC_ORIENTATION_P=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "MIF" THEN \
	  PARAM7 = ",MIF=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "HPGL" THEN \
	  PARAM7 = ",HPGL=1"  
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "LEAF" THEN \
	  PARAM7 = ",LEAF=1" 
	@ IF F$EDIT("$(HC_DEVICE)","UPCASE") .EQS. "PS" THEN \
	  PARAM7 = ",PS=1"  
	@ IF F$EDIT("$(USE_LIBHELP)","UPCASE") .EQS. "YES" THEN \
	  PARAM8 = ",USE_LIBHELP=1"     
	@ PARAM = "''PARAM'''PARAM1'''PARAM2'''PARAM3'''PARAM4'''PARAM5'\
''PARAM6'''PARAM7'''PARAM8')" 
	@ $(MMS)/IGNORE=WARNING 'PARAM' $(MMSTARGETS)	! second call	
	
.ENDIF	! SCNDCALL  
