#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "protos.h"
#include "globals.h"

#include <X11/cursorfont.h>
#include <Xm/ToggleB.h>

#ifdef LIBHELP
#include <help.h>
#endif

extern Display *disp;
extern Widget app_shell;

char* help_anchors(int anchor){
    static char s[256];
    strcpy(s,"nohelp.html");
    switch (anchor){
    case HELP_INDEX:
    	strcpy(s,"index.html");
    	break;
    case HELP_GUIDE:
    	strcpy(s,"xmgr.html");
    	break;
    case HELP_FAQ:
    	strcpy(s,"FAQ.html");
    	break;
    case HELP_CHANGES:
    	strcpy(s,"CHANGES.html");
    	break;
    case HELP_FILE_READ_SETS:
    	strcpy(s,"file.html#readsets");
    	break;
    case HELP_FILE_READ_PARS:
    	strcpy(s,"file.html#readpars");
    	break;
    case HELP_FILE_READ_BLCK:
    	strcpy(s,"file.html#readblock");
    	break;
    case HELP_FILE_WRITE_SETS:
    	strcpy(s,"file.html#writesets");
    	break;
    case HELP_FILE_WRITE_PARS:
    	strcpy(s,"file.html#writeparams");
    	break;
    case HELP_OPTS_WDIR:
    	strcpy(s,"options.html#workdir");
    	break;
    case HELP_FILE_WRITE_ALL:
    	strcpy(s,"file.html#saveall");
    	break;
    case HELP_FILE_CLEAR_ALL:
    	strcpy(s,"file.html#clearall");
    	break;
    case HELP_FILE_PRINT_SETUP:
    	strcpy(s,"file.html#printersetup");
    	break;
    case HELP_FILE_PRINT:
    	strcpy(s,"file.html#print");
    	break;
    case HELP_FILE_EXIT:
    	strcpy(s,"file.html#exit");
    	break;
    case HELP_DATA_STATUS:
    	strcpy(s,"data.html#status");
    	break;
    case HELP_DATA_RESULTS:
    	strcpy(s,"data.html#results");
    	break;
    case HELP_DATA_COMMANDS:
    	strcpy(s,"data.html#commands");
    	break;
    case HELP_MAIN:
    	strcpy(s,"main.html");
    	break;
    case HELP_TOOLBAR:
    	strcpy(s,"main.html#toolbar");
    	break;
    case HELP_TOOLBAR_DRAW:
    	strcpy(s,"main.html#draw");
    	break;
    case HELP_TOOLBAR_ZOOM:
    	strcpy(s,"main.html#zoom");
    	break;
    case HELP_TOOLBAR_AS:
    	strcpy(s,"main.html#as");
    	break;
    case HELP_TOOLBAR_EXPAND:
    	strcpy(s,"main.html#expand");
    	break;
    case HELP_TOOLBAR_SHRINK:
    	strcpy(s,"main.html#shrink");
    	break;
    case HELP_TOOLBAR_LEFT:
    	strcpy(s,"main.html#left");
    	break;
    case HELP_TOOLBAR_RIGHT:
    	strcpy(s,"main.html#right");
    	break;
    case HELP_TOOLBAR_DOWN:
    	strcpy(s,"main.html#down");
    	break;
    case HELP_TOOLBAR_UP:
    	strcpy(s,"main.html#up");
    	break;
    case HELP_TOOLBAR_AUTOTICKS:
    	strcpy(s,"main.html#autoticks");
    	break;
    case HELP_TOOLBAR_AUTOON:
    	strcpy(s,"main.html#autoon");
    	break;
    case HELP_TOOLBAR_ZOOMX:
    	strcpy(s,"main.html#zoomx");
    	break;
    case HELP_TOOLBAR_ZOOMY:
    	strcpy(s,"main.html#zoomy");
    	break;
    case HELP_TOOLBAR_AUTOX:
    	strcpy(s,"main.html#autox");
    	break;
    case HELP_TOOLBAR_AUTOY:
    	strcpy(s,"main.html#autoy");
    	break;
    case HELP_TOOLBAR_PZ:
    	strcpy(s,"main.html#pz");
    	break;
    case HELP_TOOLBAR_PU:
    	strcpy(s,"main.html#pu");
    	break;
    case HELP_TOOLBAR_PO:
    	strcpy(s,"main.html#po");
    	break;
    case HELP_TOOLBAR_CY:
    	strcpy(s,"main.html#cy");
    	break;
    case HELP_TOOLBAR_SD:
    	strcpy(s,"main.html#sd");
    	break;
    case HELP_TOOLBAR_CW:
    	strcpy(s,"main.html#cw");
    	break;
    case HELP_TOOLBAR_EXIT:
    	strcpy(s,"main.html#exit");
    	break;
    case HELP_LOCBAR:
    	strcpy(s,"main.html#locbar");
    	break;
    case HELP_STATBAR:
    	strcpy(s,"main.html#statbar");
    	break;
    case HELP_CANVAS:
    	strcpy(s,"main.html#canvas");
    	break;
    case HELP_MENUBAR:
    	strcpy(s,"main.html#menubar");
    	break;
    }
    return s;
}

void HelpCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    char URL[256];
#ifndef LIBHELP    
    int i=0, j=0;
    char command[1024];
    int len;
#endif /* LIBHELP */

    set_wait_cursor();
    
#ifdef LIBHELP
    /* xmhelp doesn't like "file://localhost/" prefix */
    sprintf(URL, "file:%s/doc/%s", xmgrdir, help_anchors ((int) client_data));
    get_help(w, (XtPointer) URL, call_data);
#else /* usual HTML browser */

    sprintf(URL, "file://localhost/%s/doc/%s", xmgrdir, help_anchors ((int) client_data));

    len = strlen(help_viewer);
    for (i = 0; i < len - 1; i++) {
    	if ((help_viewer[i] == '%') && (help_viewer[i+1] == 's')){
    	    strcpy (&command[j], URL);
    	    j += strlen(URL);
    	    i++;
    	} else {
    	    command[j++] = help_viewer[i];
    	}
    }      
#ifndef VMS    
    strcat(command, "&");    
    system(command);
#else
    system_spawn(command);
#endif

#endif /* LIBHELP */

    unset_wait_cursor();
}

void ContextHelpCB(Widget w, XtPointer client_data, XtPointer call_data)
{
        Widget whelp;
        XmToggleButtonCallbackStruct *cb_struct = call_data;
        Cursor cursor = XCreateFontCursor(disp, XC_question_arrow);
        if ((whelp = XmTrackingLocate(app_shell, cursor, False))) {
                cb_struct->reason = XmCR_HELP;
                XtCallCallbacks(whelp, XmNhelpCallback, cb_struct);
        }
        XFreeCursor(disp, cursor);
}

