/*
 * July 24, 1996
 * 
 * psbb.c - version 1
 * 
 * Created by: Ed Vigmond
 * 			ed@gut.rose.utoronto.ca
 * 
 * This file contains the routine get_bounding_box() which computes the bounding
 * box for a postscript figure. It does this by essentially creating a new device
 * which produces no output but checks each point drawn and sees if the bounding
 * box should be adjusted. I simply took the ps.c routines which calculate the
 * coordinates of where to place things and replaced fprintf() calls with calls 
 * to checkpoint().
 * 
 */
#include <stdio.h>
#include <ctype.h>

#include <stdio.h>
#include <math.h>
#include <time.h>
#include <setjmp.h>
#include "globals.h"
#include "symdefs.h"
#include "protos.h"
#include "externs.h"
#include "defines.h"
#include "ps.h"

typedef struct {
	double x1, x2, y1, y2;
	} Bbox;

Bbox bounding_box;					/* current bounding box */
Bbox frame_box;							/* graph frame			*/

extern char version[];
extern double charsize;
extern double devcharsize;
extern int ptofile;
extern char printstr[];
extern int monomode;		/* allow 2 colors */

static int pslinestyle;
int	drawing_sets = FALSE;

static int psdmode;
static int pspattern = 0;
static int psfont = 0;

static int orientflag = PORTRAIT;

int psinitgraphicsbb(int dmode);
void checkpoint( int x, int y );

double xconv(double), yconv(double), xconv_inv(int), yconv_inv(int);

static int prevx = 99999, prevy = 99999, prevmode;


void get_bounding_box( int *x1, int *x2, int *y1, int *y2, int mode )
{
	int i;
	
	psinitgraphicsbb( mode );
	bounding_box.x2 = bounding_box.y2 = 0;
	bounding_box.x1 = psxmax;
	bounding_box.y1 = psymax;
	for (i = 0; i < maxgraph; i++) {
	    if (isactive_graph(i) && !g[i].hidden) {
			if (checkon_ticks(i) && checkon_world(i)) {
		   	 	plotone(i);
		    	draw_annotation(i);
			}
		}
	}
	draw_annotation(-1);
	leavegraphics();
	*x1 = bounding_box.x1;
	*x2 = bounding_box.x2;
	*y1 = bounding_box.y1;
	*y2 = bounding_box.y2;
	if( debuglevel == 5 ) {
		fprintf( stderr, "Bounding Box (ps): %d %d %d %d\n", 
														*x1, *x2, *y1, *y2 );
		fprintf( stderr, "Bounding Box (view): %f %f %f %f\n",
					xconvps_inv(*x1), yconvps_inv(*y1),
					xconvps_inv(*x2), yconvps_inv(*y2)    );
	}
}

int pssetmodebb(int mode)
{
    char *mktemp(char *);
    if (mode % 2) {
    }
    switch (mode) {

    case 3:			/* portrait */
	orientflag = PORTRAIT;
	pscharsize = CHARS;
	if ( 1 ) {
            psxmin = PSXMIN;
            psymin = PSYMIN;
            if (devwidth == 0) {
                devwidth = PSXMAX - PSXMIN;
            }
            if (devheight == 0) {
                devheight = PSYMAX - PSYMIN;
            }
            if (((double) devheight) / devwidth >
                ((double) (PSYMAX - PSYMIN)) / (PSXMAX - PSXMIN)) {
                psymax = PSYMAX;
                psxmax = (PSYMAX - PSYMIN) * devwidth / devheight + PSXMIN;
                psdy = PSYMAX - PSYMIN;
                psdx = (PSYMAX - PSYMIN) * devwidth / devheight;
            } else {
                psxmax = PSXMAX;
                psymax = (PSXMAX - PSXMIN) * devheight / devwidth + PSYMIN;
                psdx = PSXMAX - PSXMIN;
                psdy = (PSXMAX - PSXMIN) * devheight / devwidth;
            }

            devwidth = psdx;
            devheight = psdy;
            devwidthmm = 25.4 * devwidth / 300.0;
            devheightmm = 25.4 * devheight / 300.0;

	} else {
	    psxmin = PSXMIN;
	    psxmax = PSXMAX;
	    psymin = PSYMIN;
	    psymax = PSYMAX;
	    psdx = DXPS;
	    psdy = DYPS;
	    devwidth = DXPS;
	    devheight = DYPS;
	    devwidthmm = PSWIDTHMM;
	    devheightmm = PSHEIGHTMM;
	}
	devoffsx = 0;
	devoffsy = 0;
	break;

    case 1:			/* landscape */
	orientflag = LANDSCAPE;
	pscharsize = CHARS;
	if (1) {
	    psxmin = PSYMIN;
	    psymin = PSXMIN;
	    if (devwidth == 0) {
		devwidth = PSYMAX - PSYMIN;
	    }
	    if (devheight == 0) {
		devheight = PSXMAX - PSXMIN;
	    }
	    if (((double) devheight) / devwidth >
		((double) (PSXMAX - PSXMIN)) / (PSYMAX - PSYMIN)) {
		psymax = PSXMAX;
		psxmax = (PSXMAX - PSXMIN) * devwidth / devheight + PSYMIN;
		psdy = PSXMAX - PSXMIN;
		psdx = (PSXMAX - PSXMIN) * devwidth / devheight;
	    } else {
		psxmax = PSYMAX;
		psymax = (PSYMAX - PSYMIN) * devheight / devwidth + PSXMIN;
		psdx = PSYMAX - PSYMIN;
		psdy = (PSYMAX - PSYMIN) * devheight / devwidth;
	    }
	    devwidth = psdx;
	    devheight = psdy;
	    devwidthmm = 25.4 * devwidth / 300.0;
	    devheightmm = 25.4 * devheight / 300.0;;
	} else {
	    psxmin = PSYMIN;
	    psxmax = PSYMAX;
	    psymin = PSXMIN;
	    psymax = PSXMAX;
	    psdx = DYPS;
	    psdy = DXPS;
	    devwidth = DYPS;
	    devheight = DXPS;
	    devwidthmm = PSHEIGHTMM;
	    devheightmm = PSWIDTHMM;
	}
	devoffsx = 0;
	devoffsy = 0;
	break;

    case 2:
    case 4:
	orientflag = PORTRAIT;
	break;
    }
    return mode;
}

void drawpsbb(int x2, int y2, int mode)
{
    int xtmp, ytmp;

    if (x2 < 0 || y2 < 0) {	/* Eliminate garbage on output */
	return;
    }
    xtmp = x2;
    ytmp = y2;

    if (mode) {
	if (prevmode && xtmp == prevx && ytmp == prevy) {
	    return;		/* previous mode was draw and points are the
				 * same */
	}
 	checkpoint( xtmp, ytmp);	/* moveto */
   	} else {
	/* Avoid excessive moveto's generated by grtool */
	if (xtmp == prevx && ytmp == prevy) {
	    return;
	}
	checkpoint( xtmp, ytmp);	/* moveto */
    }
    pathlength++;
    prevx = xtmp;
    prevy = ytmp;

    prevmode = mode;
    if (pathlength > MAXLINELEN) {
		prevmode = 0;
    }
}

int pssetcolorbb(int c)
{
	return c;
}

int pssetlinewidthbb(int c)
{
    return c;
}

void psdrawticbb(int x, int y, int dir, int updown)
{
    switch (dir) {
	case 0:
	switch (updown) {
	    case 0:
	    drawpsbb(x, y, 0);
	    drawpsbb(x, y + devxticl, 1);
	    break;
	case 1:
	    drawpsbb(x, y, 0);
	    drawpsbb(x, y - devxticl, 1);
	    break;
	}
	break;
    case 1:
	switch (updown) {
	case 0:
	    drawpsbb(x, y, 0);
	    drawpsbb(x + devyticl, y, 1);
	    break;
	case 1:
	    drawpsbb(x, y, 0);
	    drawpsbb(x - devyticl, y, 1);
	    break;
	}
	break;
    }
}

int pssetlinestylebb(int style)
{
    if (style == pslinestyle) {
	return (pslinestyle);
    }
    return (pslinestyle = style);
}

void pssetfontbb(int n)
{
    if (psfont == n) {
	return;
    }
    hselectfont(psfont = n);
}

void pssetfontsizebb(double size)
{
    int sf = psfont;

    psfontsize = (int) (size * 60);
    psfont = -1;
    pssetfontbb(sf);
}


void dispstrpsbb(int x, int y, int rot, char *s, int just, int fudge)
{
	double hgt, tx;
	double cosx, sinx;
	double x1 = 0, x2 = 0, y1 = 0, y2 = 0;
	
    if (psfontsize == 0 || s == NULL || strlen(s) == 0) {
	return;
    }
    hgt = stringextenty(charsize * pscharsize, "N")*1.2;
    tx =  stringextentx(charsize * pscharsize, s)*1.1;
    cosx = cos( rot*M_PI /180. );
    sinx = sin( rot*M_PI /180. );
    
    switch (just) {
    case 0:						/* left justified */
 		y1 = -hgt*.4;
 		y2 = hgt+20.;
    	x1 = 0;
    	x2 = tx;
		break;
	break;
    case 1:						/* right justified	*/
    	x1 = -tx;
    	x2 = 0;
 		y1 = -hgt;
 		y2 = hgt*.4;
 		break;
    case 2:						/* center justified	*/
    	x1 = -tx/2.;
    	x2 =  tx/2.;
    	y1 = -hgt;
    	y2 =  hgt/2.+40.;
		break;
    }
    if (fudge){
      y1 += psfontsize / 3;
      y2 += psfontsize / 3;
    }
   	checkpoint( (int)(x + x1*cosx - y1*sinx), (int)(y + x1*sinx + y1*cosx) );
    checkpoint( (int)(x + x2*cosx - y1*sinx), (int)(y + x2*sinx + y1*cosx) );
    checkpoint( (int)(x + x1*cosx - y2*sinx), (int)(y + x1*sinx + y2*cosx) );
    checkpoint( (int)(x + x2*cosx - y2*sinx), (int)(y + x2*sinx + y2*cosx) );
    if( debuglevel ==5 ) {
    	printf( "string %s: %f %f %f %f\n", s, xconvps_inv(x+x1*cosx - y1*sinx), 
    				xconvps_inv(x+x2*cosx - y2*sinx), 
    				yconvps_inv(y+x1*sinx + y1*cosx), 
    				yconvps_inv(y+x2*sinx + y2*cosx) );
    }
}


int pssetpatbb(int k)
{
    if (k > PSMAXPAT) {
	k = PSMAXPAT;
    } else if (k < 0) {
	k = 0;
    }
    return (pspattern = k);
}

void psfillbb(int n, int *px, int *py)
{
    int i;

    drawpsbb(px[0], py[0], 0);
    for (i = 1; i < n; i++) {
		drawpsbb(px[i], py[i], 1);
    }
}

void psfillcolorbb(int n, int *px, int *py)
{
    int i;

    drawpsbb(px[0], py[0], 0);
    for (i = 1; i < n; i++) {
		drawpsbb(px[i], py[i], 1);
    }
}

void psdrawarcbb(int x, int y, int r)
{
    checkpoint( x+r, y+r );
    checkpoint( x-r, y-r );
}

void psfillarcbb(int x, int y, int r)
{
    checkpoint( x+r, y+r );
    checkpoint( x-r, y-r );
}

void psdrawellipsebb(int x, int y, int xm, int ym)
{
    checkpoint( x+xm, y+ym );
    checkpoint( x-xm, y-ym );
}

void psfillellipsebb(int x, int y, int xm, int ym)
{
    checkpoint( x+xm, y+ym );
    checkpoint( x-xm, y-ym );
}

void psleavegraphicsbb(void)
{
    pssetmodebb(psdmode + 1);
}

/*           postscript initialization routine  */
int psinitgraphicsbb(int dmode)
{
    pathlength = 0;
    psdmode = dmode;
    if (!pssetmodebb(psdmode)) {
	return -1;
    }
    devconvx = xconvps;
    devconvy = yconvps;
    vector = drawpsbb;
    devwritestr = dispstrpsbb;
    devsetcolor = pssetcolorbb;
    devsetfont = pssetfontbb;
    devsetline = pssetlinestylebb;
    devsetlinew = pssetlinewidthbb;
    devdrawtic = psdrawticbb;
    devsetpat = pssetpatbb;
    devdrawarc = psdrawarcbb;
    devfillarc = psfillarcbb;
    devfill = psfillbb;
    devfillcolor = psfillcolorbb;
    devdrawellipse = psdrawellipsebb;
    devfillellipse = psfillellipsebb;
    devfillellipsecolour = psfillellipsebb;
   	devleavegraphics = psleavegraphicsbb;
    devcharsize = pscharsize;
    devsymsize = 20;
    devxticl = 20;
    devyticl = 20;
    devarrowlength = 20;
    psfont = -1;
    setfont(2);
    return 0;
}


void checkpoint( int x, int y ) /*check if point is in current bounding box*/
{
	/* make sure sets are clipped to frame */
	if( drawing_sets && ( x<frame_box.x1 || x>frame_box.x2 || 
						  y<frame_box.y1 || y>frame_box.y2   ) )
		return;
	
	/* make sure a valid point is checked. If outside the page, return */
	if( x<0 || y<0 || x>psxmax || y>psymax )
		return;

	if( x<bounding_box.x1 )
		bounding_box.x1 = x;
	if( x>bounding_box.x2 )
		bounding_box.x2 = x;
	if( y<bounding_box.y1 )
		bounding_box.y1 = y;
	if( y>bounding_box.y2 )
		bounding_box.y2 = y;
}


/* 
 * get bounding box pf graph frame */
void set_frame_bound( int gno )
{
	world w;
	
	get_graph_world( gno, &w );
	if( w.xg1>w.xg2 )
		fswap( &w.xg1, &w.xg1 );
	if( w.yg1>w.yg2 )
		fswap( &w.yg1, &w.yg1 );
	frame_box.x1 = xconvps( w.xg1 );
	frame_box.x2 = xconvps( w.xg2 );
	frame_box.y1 = yconvps( w.yg1 );
	frame_box.y2 = yconvps( w.yg2 );
	drawing_sets = TRUE;
}


void set_drawing_finished()
{
	drawing_sets = FALSE;
}
