/* $Id: xmgr.c,v 1.3 1995/06/04 20:00:26 pturner Exp pturner $
 *
 * main loop
 *
 * Has Motif and X specific variable declarations
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>

#ifdef VMS
#  include <unixlib.h>
#  include <unixio.h>
#  include "vms_unix.h"
#endif

#include <X11/X.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/keysym.h>
#include <X11/StringDefs.h>

#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/CascadeB.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/BulletinB.h>
#include <Xm/FileSB.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/ScrolledW.h>

#include "globals.h"
#include "protos.h"
#include "motifinc.h"
#include "bitmaps.h"

void create_workingdir_popup(Widget w, XtPointer client_data, XtPointer call_data);

#ifdef DRAGnDROP
/* testing drag n drop */
#include <Xm/DragDrop.h>
void (*drop_proc) ();
Cardinal numImportTargets;
Atom FILE_CONTENTS, FILE_NAME;
Atom *importTargets, *newTargets;
Atom importList[2];
void HandleDropLabel(), HandleDropText();
void init_dragndrop(void);
#endif

/*
 * used to set up XmStrings
 * Seems to be some problems under AIX, the #ifdef is supposed to
 * take care of the problem.
 */
#ifdef XmFONTLIST_DEFAULT_TAG
XmStringCharSet charset = (XmStringCharSet) XmFONTLIST_DEFAULT_TAG;
#else
XmStringCharSet charset = (XmStringCharSet) XmSTRING_DEFAULT_CHARSET;
#endif

XtAppContext app_con;

/* used globally */
Widget app_shell;
Widget canvas;
Widget pagew[4];		/* toggle buttons for page layouts */

static Widget scrollw;		/* container for drawing area */

Widget loclab;			/* locator label */
Widget statlab;			/* status line at the bottom */
Widget stack_depth_item;	/* stack depth item on the main panel */
Widget curw_item;		/* current world stack item on the main panel */
XmString string;		/* string for current location */
XmString sdstring;		/* string for stack depth */
XmString cystring;		/* string for stack cycle */
XmString statstring;		/* string for pointer status */

extern Colormap mycmap;		/* colormap for canvas */
extern Display *disp;
extern GC gc;
extern GC gcxor;
extern GC gcclr;
extern XGCValues gc_val;
extern Window xwin;
extern unsigned long colors[];

/* used locally */
static Widget main_frame;
static Widget menu_pane;
static Widget menu_bar;
static Widget frleft, frtop, frbot;	/* dialogs along canvas edge */
static Widget form;		/* form for mainwindow */

static void MenuCB(Widget w, XtPointer client_data, XtPointer call_data);
static Widget CreateMenuBar(Widget parent);
static void init_pm(void);
static void set_pipetimer(void);

/*
 * for buttons on front panel
 */

static Pixmap zoompm, shrinkpm, expandpm, autopm;
static Pixmap uppm, leftpm, downpm, rightpm;

/*
 * establish resource stuff
 */
typedef struct {
    Boolean invert;
    Boolean revflag;
    Boolean backingstore;
    Boolean allow_dc;
    Boolean autoscale_onread;
    Boolean verify_action;
    Boolean auto_redraw;
    Boolean allow_refresh;
    int maxplot;
    int maxgraph;
    int maxcolors;
    Boolean noask;
    Boolean logwindow;
}

ApplicationData, *ApplicationDataPtr;

static XtResource resources[] =
{
    {"invertDraw", "InvertDraw", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, invert), XtRImmediate,
     (XtPointer) FALSE},
    {"reverseVideo", "ReverseVideo", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, revflag), XtRImmediate,
     (XtPointer) FALSE},
    {"backingstore", "Backingstore", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, backingstore), XtRImmediate,
     (XtPointer) FALSE},
    {"allowDoubleClick", "AllowDoubleClick", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, allow_dc), XtRImmediate,
     (XtPointer) TRUE},
    {"autoscaleOnRead", "AutoscaleOnRead", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, autoscale_onread), XtRImmediate,
     (XtPointer) FALSE},
    {"verifyAction", "VerifyAction", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, verify_action), XtRImmediate,
     (XtPointer) FALSE},
    {"maxSets", "MaxSets", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, maxplot), XtRImmediate,
     (XtPointer) MAXPLOT},
    {"maxGraphs", "MaxGraphs", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, maxgraph), XtRImmediate,
     (XtPointer) MAXGRAPH},
    {"maxColors", "MaxColors", XtRInt, sizeof(int),
     XtOffset(ApplicationDataPtr, maxcolors), XtRImmediate,
     (XtPointer) MAXCOLORS},
    {"allowRefresh", "AllowRefresh", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, allow_refresh), XtRImmediate,
     (XtPointer) TRUE},
    {"allowRedraw", "AllowRedraw", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, auto_redraw), XtRImmediate,
     (XtPointer) TRUE},
    {"noAsk", "NoAsk", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, noask), XtRImmediate,
     (XtPointer) FALSE},
    {"logWindow", "LogWindow", XtRBoolean, sizeof(Boolean),
     XtOffset(ApplicationDataPtr, logwindow), XtRImmediate,
     (XtPointer) FALSE},
};

/*
 * put the current working directory in the title bar
 */
void set_title(char *ts)
{
    if (ts == NULL) {
	if (getcwd(buf, 1023) != NULL) {
	    strcpy(workingdir, buf);
	    XtVaSetValues(app_shell, XtNtitle, buf, NULL);
	    /* free(buf); */
	}
    } else {
	XtVaSetValues(app_shell, XtNtitle, ts, NULL);
    }
}

/*
 * initialize the X-Toolkit
 */
void initialize_screen(int *argc, char **argv)
{
    ApplicationData rd;

    app_shell = XtAppInitialize(&app_con, "XMgr", NULL, 0, argc, argv, NULL, NULL, 0);
    savewidget(app_shell);
    disp = XtDisplay(app_shell);
    if (!disp) {
	sprintf(buf, "%s: can't open display, exiting...", argv[0]);
	XtWarning(buf);
	exit(0);
    }
#ifdef DRAGnDROP
    FILE_CONTENTS = XmInternAtom(disp, "FILE_CONTENTS", False);
    FILE_NAME = XmInternAtom(disp, "FILE_NAME", False);
#endif

    use_colors = DisplayPlanes(disp, DefaultScreen(disp));
    if (use_colors < 8) {
	use_colors = 1;
    }
    XtGetApplicationResources(app_shell, &rd, resources,
			      XtNumber(resources), NULL, 0);
    invert = rd.invert;
    revflag = rd.revflag;
    backingstore = rd.backingstore;
    allow_dc = rd.allow_dc;
    autoscale_onread = rd.autoscale_onread;
    verify_action = rd.verify_action;
    maxplot = rd.maxplot;
    maxgraph = rd.maxgraph;
    maxcolors = rd.maxcolors;
    logwindow = rd.logwindow;
    auto_redraw = rd.auto_redraw;
    allow_refresh = rd.allow_refresh;
}


/*
 * exit xmgr
 */
void bailout(void)
{
    if (resfp) {
	fclose(resfp);
    }
    exit(0);
}

/*
 * main menubar
 */
/* #define MENU_HELP	200 */
#define MENU_EXIT	201
#define MENU_CLEAR	202
/* #define MENU_NEW	203 */
#define MENU_OPEN	204
#define MENU_SAVE	205
#define MENU_SAVEAS	206
#define MENU_PRINT	207

static void MenuCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    switch ((int) client_data) {
/*
 *     case MENU_HELP:
 * 	create_help_frame(NULL, NULL, NULL);
 * 	break;
 */ 
    case MENU_EXIT:
	if (yesno("Exit xmgr? Are you sure?", NULL, NULL, NULL)) {
	    bailout();
	}
	break;
    case MENU_CLEAR:
	wipeout(1);
	set_graph_active(cg = 0);
	update_all(cg);
	drawgraph();
	break;
/*
 *     case MENU_NEW:
 * 	if (dirtyflag) {
 * 	    if (yesno("Current project has been modified, save?", NULL, NULL, NULL)) {
 * 		create_saveproject_popup();
 * 	    }
 * 	}
 * 	create_newproject_popup();
 * 	break;
 */
    case MENU_OPEN:
	if (dirtyflag) {
	    if (yesno("Current project has been modified, save?", NULL, NULL, NULL)) {
		create_saveproject_popup();
	    }
	}
	create_openproject_popup();
	break;
    case MENU_SAVE:
	if (strcmp (docname, NONAME) != 0) {
	    set_wait_cursor();
	    
	    if (curptype == BINARY) {
	    	if (putbinary(cg, docname, 0) != 1) {
	    	    dirtyflag = 0;
	    	} 
	    } else {
	    	if (do_writesets(maxgraph, -1, 1, docname, sformat) != 1) {
	    	    dirtyflag = 0;
	    	}
	    }
	    
	    unset_wait_cursor();
	    drawgraph();
	} else {
	    create_saveproject_popup();
	}
	break;
    case MENU_SAVEAS:
	create_saveproject_popup();
	break;
    case MENU_PRINT:
	set_wait_cursor();
	do_hardcopy();
	unset_wait_cursor();
	break;
    default:
	break;
    }
}

/*
 * service the autoscale buttons on the main panel
 */
void autoscale_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    if (activeset(cg)) {
	switch ((int) client_data) {
	case 0:
	    autoscale_graph(cg, -3);
	    break;
	case 1:
	    autoscale_graph(cg, -2);
	    break;
	case 2:
	    autoscale_graph(cg, -1);
	    break;
	}
	drawgraph();
    } else {
	errwin("No active sets!");
    }
}

void autoon_proc(void)
{
    set_action(0);
    set_action(AUTO_NEAREST);
}

/*
 * service the auticks button on the main panel
 */
void autoticks_proc(Widget w, XtPointer client_data, XtPointer call_data)
{
    default_axis(cg, g[cg].auto_type, X_AXIS);
    default_axis(cg, g[cg].auto_type, ZX_AXIS);
    default_axis(cg, g[cg].auto_type, Y_AXIS);
    default_axis(cg, g[cg].auto_type, ZY_AXIS);
    update_all(cg);
    drawgraph();
}

/*
 * set the message in the left footer
 */
void set_left_footer(char *s)
{
    Arg al;

    XmStringFree(statstring);
    statstring = XmStringCreateLtoR(s, charset);
    XtSetArg(al, XmNlabelString, statstring);
    XtSetValues(statlab, &al, 1);
    if (logwindow) {
	log_results(s);
    }
    XmUpdateDisplay(statlab);
}


/*
 * clear the locator reference point
 */
void do_clear_point(Widget w, XtPointer client_data, XtPointer call_data)
{
    g[cg].pointset = FALSE;
    g[cg].pt_type = 0;
    g[cg].dsx = g[cg].dsy = 0.0;
}

/*
 * set visibility of the toolbars
 */
int toolbar_visible = 1;
int statusbar_visible = 1;
int locbar_visible = 1;

static Widget windowbarw[3];

static void set_view_items()
{
    if (statusbar_visible) {
	XmToggleButtonSetState(windowbarw[1], True, False);
	XtManageChild(frbot);
	XtVaSetValues(scrollw,
		      XmNbottomAttachment, XmATTACH_WIDGET,
		      XmNbottomWidget, frbot,
		      NULL);
	if (toolbar_visible) {
	    XtVaSetValues(frleft,
			  XmNbottomAttachment, XmATTACH_WIDGET,
			  XmNbottomWidget, frbot,
			  NULL);
	}
    } else {
	XmToggleButtonSetState(windowbarw[1], False, False);
	XtVaSetValues(scrollw,
		      XmNbottomAttachment, XmATTACH_FORM,
		      NULL);
	XtUnmanageChild(frbot);
	if (toolbar_visible) {
	    XtVaSetValues(frleft,
			  XmNbottomAttachment, XmATTACH_FORM,
			  NULL);
	}
    }
    if (toolbar_visible) {
	XmToggleButtonSetState(windowbarw[2], True, False);
	XtManageChild(frleft);
	if (statusbar_visible) {
	    XtVaSetValues(frleft,
			  XmNbottomAttachment, XmATTACH_WIDGET,
			  XmNbottomWidget, frbot,
			  NULL);
	}
	if (locbar_visible) {
	    XtVaSetValues(frleft,
			  XmNtopAttachment, XmATTACH_WIDGET,
			  XmNtopWidget, frtop,
			  NULL);
	}
	XtVaSetValues(scrollw,
		      XmNleftAttachment, XmATTACH_WIDGET,
		      XmNleftWidget, frleft,
		      NULL);
    } else {
	XmToggleButtonSetState(windowbarw[2], False, False);
	XtUnmanageChild(frleft);
	XtVaSetValues(scrollw,
		      XmNleftAttachment, XmATTACH_FORM,
		      NULL);
    }
    if (locbar_visible) {
	XmToggleButtonSetState(windowbarw[0], True, False);
	XtManageChild(frtop);
	XtVaSetValues(scrollw,
		      XmNtopAttachment, XmATTACH_WIDGET,
		      XmNtopWidget, frtop,
		      NULL);
	if (toolbar_visible) {
	    XtVaSetValues(frleft,
			  XmNtopAttachment, XmATTACH_WIDGET,
			  XmNtopWidget, frtop,
			  NULL);
	}
    } else {
	XmToggleButtonSetState(windowbarw[0], False, False);
	XtUnmanageChild(frtop);
	XtVaSetValues(scrollw,
		      XmNtopAttachment, XmATTACH_FORM,
		      NULL);
	if (toolbar_visible) {
	    XtVaSetValues(frleft,
			  XmNtopAttachment, XmATTACH_FORM,
			  NULL);
	}
    }
}

/*
 * called from the parser
 */
void set_toolbars(int bar, int onoff)
{
    switch (bar) {
    case TOOLBAR:
	toolbar_visible = onoff;
	break;
    case STATUSBAR:
	statusbar_visible = onoff;
	break;
    case LOCATORBAR:
	locbar_visible = onoff;
	break;
    }
    if (inwin) {
	set_view_items();
    }
}

/*
 * service routines for the View pulldown
 */
void set_statusbar(Widget w, XtPointer client_data, XtPointer call_data)
{
    if (XmToggleButtonGetState(w)) {
	statusbar_visible = 1;
    } else {
	statusbar_visible = 0;
    }
    set_view_items();
}

void set_toolbar(Widget w, XtPointer client_data, XtPointer call_data)
{
    if (XmToggleButtonGetState(w)) {
	toolbar_visible = 1;
    } else {
	toolbar_visible = 0;
    }
    set_view_items();
}

void set_locbar(Widget w, XtPointer client_data, XtPointer call_data)
{
    if (XmToggleButtonGetState(w)) {
	locbar_visible = 1;
    } else {
	locbar_visible = 0;
    }
    set_view_items();
}

/*
 * set the canvas size
 */
void set_canvas_size(int w, int h, int o)
{
    Dimension px, py;
    px = w;
    py = h;
    XtVaSetValues(canvas,
		  XmNwidth, px,
		  XmNheight, py,
		  NULL);
}

void get_default_canvas_size(int *w, int *h)
{
    Dimension ww, wh;
    Arg args;
    XtSetArg(args, XmNwidth, &ww);
    XtGetValues(scrollw, &args, 1);
    XtSetArg(args, XmNheight, &wh);
    XtGetValues(scrollw, &args, 1);
    *w = ww - 5;
    *h = wh - 5;
}

/*
 * service the Page pulldown item
 */
void set_page(Widget w, XtPointer client_data, XtPointer call_data)
{
    int i;
    double wx1, wx2, wy1, wy2;
    Dimension px, py;
    int pageorient = (int) client_data;
    wx1 = DisplayWidth(disp, DefaultScreen(disp));
    wx2 = DisplayWidthMM(disp, DefaultScreen(disp));
    wy1 = DisplayHeight(disp, DefaultScreen(disp));
    wy2 = DisplayHeightMM(disp, DefaultScreen(disp));
    px = (Dimension) (wx1 / wx2 * (8.5 * 25.4));
    py = (Dimension) (wy1 / wy2 * (11.5 * 25.4));

    switch (pageorient) {
    case LANDSCAPE:
	page_layout = LANDSCAPE;
	XtVaSetValues(canvas,
		      XmNwidth, py,
		      XmNheight, px,
		      NULL);
	break;
    case PORTRAIT:
	page_layout = PORTRAIT;
	XtVaSetValues(canvas,
		      XmNwidth, px,
		      XmNheight, py,
		      NULL);
	break;
    case FIXED:
	page_layout = FIXED;
	XtVaSetValues(canvas,
		      XmNwidth, canvasw,
		      XmNheight, canvash,
		      NULL);
	break;
    case FREE:			/* falls through */
    default:
	page_layout = FREE;
	{
	    int w, h;
	    get_default_canvas_size(&w, &h);
	    px = w;
	    py = h;
	    XtVaSetValues(canvas,
			  XmNwidth, px,
			  XmNheight, py,
			  NULL);
	}
	break;
    }
    for (i = 0; i < 4; i++) {
	XmToggleButtonSetState(pagew[i], False, False);
    }
    XmToggleButtonSetState(pagew[get_pagelayout()], True, False);
}

/*
 * get/set page layouts - returns the index into the array
 * of ToggleButton widgets
 */
int get_pagelayout()
{
    switch (page_layout) {
    case FREE:
	return 0;
    case LANDSCAPE:
	return 1;
    case PORTRAIT:
	return 2;
    case FIXED:
	return 3;
    default:
    	return 0;
    }
}

int set_pagelayout(int layout)
{
    page_layout = layout;
    if (inwin) {
	set_page(NULL, (XtPointer) page_layout, NULL);
    }
    return page_layout;
}


/*
 * create the main menubar
 */
static Widget CreateMenuBar(Widget parent)
{
    Widget menu_bar;
    Widget cascade;
    Widget button;
    Widget pulldown;
    Arg args[10];
    int ac = 0;

#ifdef XmNtearOffModel
    XtSetArg(args[0], XmNtearOffModel, XmTEAR_OFF_ENABLED);
    ac = 1;
#endif

    menu_bar = XmCreateMenuBar(parent, "menu_bar", NULL, 0);
    XtAddCallback(menu_bar, XmNhelpCallback, 
    	(XtCallbackProc) HelpCB, (XtPointer) HELP_MENUBAR);

/*
 * File menu
 */
    menu_pane = XmCreatePulldownMenu(menu_bar, "Files menu", args, ac);

    button = CreateMenuButton(menu_pane, "Open...", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_OPEN, HELP_FILE_OPEN);
    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("Ctrl+O", charset),
    	XmNaccelerator, "Ctrl <Key>O", NULL);

    button = CreateMenuButton(menu_pane, "Save", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_SAVE, HELP_FILE_SAVE);
    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("Ctrl+S", charset),
    	XmNaccelerator, "Ctrl <Key>S", NULL);

    (void) CreateMenuButton(menu_pane, "Save as...", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_SAVEAS, HELP_FILE_SAVEAS);

    (void) CreateMenuButton(menu_pane, "Describe...", 
    	(XtCallbackProc) create_describe_popup, NULL, 0);


    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

/*
 * Read submenu
 */

    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", NULL, 0);
    (void) XtVaCreateManagedWidget("Read", xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString, XmStringCreateSimple("Read"), NULL);
    

    (void) CreateMenuButton(pulldown, "Sets...", 
    	(XtCallbackProc) create_file_popup, (XtPointer) NULL, HELP_FILE_READ_SETS);

#ifdef HAVE_MFHDF
    (void) CreateMenuButton(pulldown, "NetCDF/HDF...", 
    	(XtCallbackProc) create_netcdfs_popup, (XtPointer) NULL, HELP_FILE_READ_CDF);
#else

#ifdef HAVE_NETCDF
    (void) CreateMenuButton(pulldown, "NetCDF...", 
    	(XtCallbackProc) create_netcdfs_popup, (XtPointer) NULL, HELP_FILE_READ_CDF);
#endif

#endif
    (void) CreateMenuButton(pulldown, "Parameters...", 
    	(XtCallbackProc) create_rparams_popup, (XtPointer) NULL, HELP_FILE_READ_PARS);

    (void) CreateMenuButton(pulldown, "Block data...", 
    	(XtCallbackProc) create_block_popup, (XtPointer) NULL, HELP_FILE_READ_BLCK);

    (void) CreateMenuButton(pulldown, "Image...", 
    	(XtCallbackProc) create_image_frame, (XtPointer) NULL, 0);
   
/*
 * Write submenu
 */  
    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", NULL, 0);
    (void) XtVaCreateManagedWidget("Write", xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString, XmStringCreateSimple("Write"), NULL);

    (void) CreateMenuButton(pulldown, "Sets...", 
    	(XtCallbackProc) create_write_popup, (XtPointer) NULL, HELP_FILE_WRITE_SETS);

    (void) CreateMenuButton(pulldown, "Parameters...", 
    	(XtCallbackProc) create_wparam_frame, (XtPointer) NULL, HELP_FILE_WRITE_PARS);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, 
    	menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Clear all...", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_CLEAR, HELP_FILE_CLEAR_ALL);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, 
    	menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Print", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_PRINT, HELP_FILE_PRINT);

    (void) CreateMenuButton(menu_pane, "Printer setup...", 
    	(XtCallbackProc) create_printer_setup, (XtPointer) NULL, HELP_FILE_PRINT_SETUP);


    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane,
		NULL);

    button = CreateMenuButton(menu_pane, "Exit", 
    	(XtCallbackProc) MenuCB, (XtPointer) MENU_EXIT, HELP_FILE_EXIT);
    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("Ctrl+Q", charset),
    	XmNaccelerator, "Ctrl <Key>Q", NULL);

    (void) XtVaCreateManagedWidget("File", xmCascadeButtonWidgetClass, menu_bar,
		XmNsubMenuId, menu_pane, XmNmnemonic, 'F', NULL);

/*
 * Data menu
 */
    menu_pane = XmCreatePulldownMenu(menu_bar, "Datamenu_pane", args, ac);

    button = CreateMenuButton(menu_pane, "Status...", 
    	(XtCallbackProc) define_status_popup, (XtPointer) NULL, 0);
    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("F5", charset),
    	XmNaccelerator, "<Key>F5", NULL);

    (void) CreateMenuButton(menu_pane, "Results...", 
    	(XtCallbackProc) create_monitor_frame, (XtPointer) NULL, 0);
    
    button = CreateMenuButton(menu_pane, "Commands...", 
    	(XtCallbackProc) open_command, (XtPointer) NULL, 0);
    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("F4", charset),
    	XmNaccelerator, "<Key>F4", NULL);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);


    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", args, ac);
    (void) XtVaCreateManagedWidget("Transformations", xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString, XmStringCreateSimple("Transformations"), NULL);

    	(void) CreateMenuButton(pulldown, "Evaluate expression...", 
    	    (XtCallbackProc) create_eval_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Load values...", 
    	    (XtCallbackProc) create_load_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Load & evaluate...", 
    	    (XtCallbackProc) create_leval_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Histograms...", 
    	    (XtCallbackProc) create_histo_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Fourier transforms...", 
    	    (XtCallbackProc) create_fourier_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Running averages...", 
    	    (XtCallbackProc) create_run_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Regression...", 
    	    (XtCallbackProc) create_reg_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Non-linear curve fitting...", 
    	    (XtCallbackProc) create_nonl_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Differences...", 
    	    (XtCallbackProc) create_diff_frame, (XtPointer) NULL, 0);
    	    
    	(void) CreateMenuButton(pulldown, "Seasonal differences...", 
    	    (XtCallbackProc) create_seasonal_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Integration...", 
    	    (XtCallbackProc) create_int_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Cross/auto correlation...", 
    	    (XtCallbackProc) create_xcor_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Interpolation...", 
    	    (XtCallbackProc) create_interp_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Splines...", 
    	    (XtCallbackProc) create_spline_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Sample points...", 
    	    (XtCallbackProc) create_samp_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Digital filter...", 
    	    (XtCallbackProc) create_digf_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Linear convolution...", 
    	    (XtCallbackProc) create_lconv_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "N-tiles...", 
    	    (XtCallbackProc) create_ntiles_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Geometric transformations...", 
    	    (XtCallbackProc) create_geom_frame, (XtPointer) NULL, 0);
    	    

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Point operations...", 
    	(XtCallbackProc) create_points_frame, (XtPointer) NULL, 0);



    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", args, ac);
    (void) XtVaCreateManagedWidget("Set operations",
    xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString,
    	XmStringCreateSimple("Set operations"), NULL);

    	(void) CreateMenuButton(pulldown, "Pick ops...", 
    	    (XtCallbackProc) define_pickops_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Activate...", 
    	    (XtCallbackProc) create_activate_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "De-activate...", 
    	    (XtCallbackProc) create_deactivate_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Re-activate...", 
    	    (XtCallbackProc) create_reactivate_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Set length...", 
    	    (XtCallbackProc) create_setlength_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Change set type...", 
    	    (XtCallbackProc) create_change_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Copy...", 
    	    (XtCallbackProc) create_copy_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Move...", 
    	    (XtCallbackProc) create_move_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Drop points...", 
    	    (XtCallbackProc) create_drop_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Join sets...", 
    	    (XtCallbackProc) create_join_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Split...", 
    	    (XtCallbackProc) create_split_popup, (XtPointer) NULL, 0);
    	    
    	(void) CreateMenuButton(pulldown, "Kill...", 
    	    (XtCallbackProc) create_kill_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Kill all", 
    	    (XtCallbackProc) do_flush, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Sort...", 
    	    (XtCallbackProc) create_sort_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Reverse sets...", 
    	    (XtCallbackProc) create_reverse_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Coalesce sets...", 
    	    (XtCallbackProc) create_coalesce_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Swap sets...", 
    	    (XtCallbackProc) create_swap_popup, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Pack sets", 
    	    (XtCallbackProc) do_packsets, (XtPointer) NULL, 0);


    
    (void) CreateMenuButton(menu_pane, "Edit/create set...", 
    	(XtCallbackProc) create_editp_frame, (XtPointer) NULL, 0);




    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", args, ac);
    (void) XtVaCreateManagedWidget("Region operations",
    xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString,
    	XmStringCreateSimple("Region operations"), NULL);

    	(void) CreateMenuButton(pulldown, "Define region...", 
    	    (XtCallbackProc) create_define_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Evaluate region...", 
    	    (XtCallbackProc) create_evalregion_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Clear region...", 
    	    (XtCallbackProc) create_clear_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Extract points...", 
    	    (XtCallbackProc) create_extract_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Extract sets...", 
    	    (XtCallbackProc) create_extractsets_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Delete points...", 
    	    (XtCallbackProc) create_delete_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Kill sets...", 
    	    (XtCallbackProc) create_deletesets_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Report on...", 
    	    (XtCallbackProc) create_reporton_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Area/perimeter...", 
    	    (XtCallbackProc) create_area_frame, (XtPointer) NULL, 0);



    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", args, ac);
    (void) XtVaCreateManagedWidget("Graph operations",
    xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString,
    	XmStringCreateSimple("Graph operations"), NULL);

    	(void) CreateMenuButton(pulldown, "Activate...", 
    	    (XtCallbackProc) create_gactive_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Copy...", 
    	    (XtCallbackProc) create_gcopy_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Swap...", 
    	    (XtCallbackProc) create_gswap_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Kill...", 
    	    (XtCallbackProc) create_gkill_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Focus...", 
    	    (XtCallbackProc) create_gfocus_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Show...", 
    	    (XtCallbackProc) create_gshow_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Set graph type...", 
    	    (XtCallbackProc) create_gtype_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Arrange...", 
    	    (XtCallbackProc) create_arrange_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Overlay...", 
    	    (XtCallbackProc) create_overlay_frame, (XtPointer) NULL, 0);

    	(void) CreateMenuButton(pulldown, "Invert/flip axes...", 
    	    (XtCallbackProc) create_ginvert_frame, (XtPointer) NULL, 0);



    (void) CreateMenuButton(menu_pane, "Block data...", 
    	(XtCallbackProc) create_eblock_frame, (XtPointer) NULL, 0);
    
    (void) CreateMenuButton(menu_pane, "Hot links...", 
    	(XtCallbackProc) create_hotlinks_popup, (XtPointer) NULL, 0);

    (void) XtVaCreateManagedWidget("Data", xmCascadeButtonWidgetClass, menu_bar,
	XmNsubMenuId, menu_pane, XmNmnemonic, 'D', NULL);


/* Plot menu */
    menu_pane = XmCreatePulldownMenu(menu_bar, "Plotmenu_pane", args, ac);

    (void) CreateMenuButton(menu_pane, "World scaling...", 
    	(XtCallbackProc) create_world_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Viewport...", 
    	(XtCallbackProc) create_view_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Autoscale...", 
    	(XtCallbackProc) create_autos_frame, (XtPointer) NULL, 0);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Titles...", 
    	(XtCallbackProc) create_label_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Tick labels/tick marks...", 
    	(XtCallbackProc) create_ticks_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Frame...", 
    	(XtCallbackProc) create_frame_frame, (XtPointer) NULL, 0);

    button = XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Symbols...", 
    	(XtCallbackProc) define_symbols_popup, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Error bars...", 
    	(XtCallbackProc) define_errbar_popup, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Legends...", 
    	(XtCallbackProc) define_legend_popup, (XtPointer) NULL, 0);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "Strings & things...", 
    	(XtCallbackProc) define_objects_popup, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Time stamp...", 
    	(XtCallbackProc) create_misc_frame, (XtPointer) NULL, 0);

    (void) XtVaCreateManagedWidget("Plot", xmCascadeButtonWidgetClass, menu_bar,
	XmNsubMenuId, menu_pane, XmNmnemonic, 'P', NULL);


/* Options menu */
    menu_pane = XmCreatePulldownMenu(menu_bar, "Options_pane", args, ac);
   
    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", NULL, 0);
    (void) XtVaCreateManagedWidget("Page", xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString, XmStringCreateSimple("Page"), NULL);
    XtVaSetValues(pulldown, XmNradioBehavior, True, NULL);
    {
	pagew[0] = XmCreateToggleButton(pulldown, "Free", NULL, 0);
	pagew[1] = XmCreateToggleButton(pulldown, "Landscape", NULL, 0);
	pagew[2] = XmCreateToggleButton(pulldown, "Portrait", NULL, 0);
	pagew[3] = XmCreateToggleButton(pulldown, "Fixed", NULL, 0);
	XtAddCallback(pagew[0], XmNvalueChangedCallback, set_page, (XtPointer) FREE);
	XtVaSetValues(pagew[0], XmNvisibleWhenOff, True, NULL);
	XtAddCallback(pagew[1], XmNvalueChangedCallback, set_page, (XtPointer) LANDSCAPE);
	XtVaSetValues(pagew[1], XmNvisibleWhenOff, True, NULL);
	XtAddCallback(pagew[2], XmNvalueChangedCallback, set_page, (XtPointer) PORTRAIT);
	XtVaSetValues(pagew[2], XmNvisibleWhenOff, True, NULL);
	XtAddCallback(pagew[3], XmNvalueChangedCallback, set_page, (XtPointer) FIXED);
	XtVaSetValues(pagew[3], XmNvisibleWhenOff, True, NULL);
	XtManageChildren(pagew, 4);

	(void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, pulldown, NULL);

    	(void) CreateMenuButton(pulldown, "Size...", 
    	    (XtCallbackProc) create_page_frame, (XtPointer) NULL, 0);
    }
	
    
    pulldown = XmCreatePulldownMenu(menu_pane, "pulldown", NULL, 0);
    (void) XtVaCreateManagedWidget("View", xmCascadeButtonWidgetClass, menu_pane,
    	XmNsubMenuId, pulldown, XmNlabelString, XmStringCreateSimple("View"), NULL);

    windowbarw[0] = XtVaCreateManagedWidget("Locator bar", xmToggleButtonWidgetClass, pulldown,
					    XmNindicatorOn, True,
					    XmNvisibleWhenOff, False,
					    NULL);
    XtAddCallback(windowbarw[0], XmNvalueChangedCallback,
		  (XtCallbackProc) set_locbar, (XtPointer) & frtop);
		  
    windowbarw[1] = XtVaCreateManagedWidget("Status bar", xmToggleButtonWidgetClass, pulldown,
					    XmNindicatorOn, True,
					    XmNvisibleWhenOff, False,
					    NULL);
    XtAddCallback(windowbarw[1], XmNvalueChangedCallback,
		  (XtCallbackProc) set_statusbar, (XtPointer) & frbot);
		  
    windowbarw[2] = XtVaCreateManagedWidget("Tool bar", xmToggleButtonWidgetClass, pulldown,
					    XmNindicatorOn, True,
					    XmNvisibleWhenOff, False,
					    NULL);
    XtAddCallback(windowbarw[2], XmNvalueChangedCallback,
		  (XtCallbackProc) set_toolbar, (XtPointer) & frleft);

    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, pulldown,
				     NULL);

    (void) CreateMenuButton(pulldown, "Set locator fixed point", 
    	(XtCallbackProc) set_actioncb, (XtPointer) SEL_POINT, 0);

    (void) CreateMenuButton(pulldown, "Clear locator fixed point", 
    	(XtCallbackProc) do_clear_point, (XtPointer) NULL, 0);

    (void) CreateMenuButton(pulldown, "Locator props...", 
    	(XtCallbackProc) create_locator_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Draw...", 
    	(XtCallbackProc) create_draw_frame, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Working directory...", 
    	(XtCallbackProc) create_workingdir_popup, (XtPointer) NULL, 0);

    (void) CreateMenuButton(menu_pane, "Misc...", 
    	(XtCallbackProc) create_props_frame, (XtPointer) NULL, 0);


    (void) XtVaCreateManagedWidget("Options", xmCascadeButtonWidgetClass, menu_bar,
	XmNsubMenuId, menu_pane, XmNmnemonic, 'O', NULL);

/* help menu */

    menu_pane = XmCreatePulldownMenu(menu_bar, "Help menu pane", args, ac);

/*
 *     button = CreateMenuButton(menu_pane, "Help...", 
 *     	(XtCallbackProc) HelpCB, (XtPointer) HELP_INDEX, 0);
 * 
 *     XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("F1", charset),
 * 	XmNaccelerator, "<Key>F1", NULL);
 */

    button = CreateMenuButton(menu_pane, "On context", 
    	(XtCallbackProc) ContextHelpCB, (XtPointer) NULL, 0);

    XtVaSetValues(button, XmNacceleratorText, XmStringCreateLtoR("Shift+F1", charset),
	XmNaccelerator, "Shift <Key>F1", NULL);

    (void) CreateMenuButton(menu_pane, "User Guide", 
    	(XtCallbackProc) HelpCB, (XtPointer) HELP_GUIDE, 0);
    
    (void) CreateMenuButton(menu_pane, "FAQ", 
    	(XtCallbackProc) HelpCB, (XtPointer) HELP_FAQ, 0);

    (void) CreateMenuButton(menu_pane, "Changes", 
    	(XtCallbackProc) HelpCB, (XtPointer) HELP_CHANGES, 0);
    	    
    (void) XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, menu_pane, NULL);

    (void) CreateMenuButton(menu_pane, "About...", 
    	(XtCallbackProc) create_about_grtool, (XtPointer) NULL, 0);

    cascade = XtVaCreateManagedWidget("Help", xmCascadeButtonWidgetClass, menu_bar,
	XmNsubMenuId, menu_pane, XmNmnemonic, 'H', NULL);
    XtVaSetValues(menu_bar, XmNmenuHelpWidget, cascade, NULL);


    return (menu_bar);
}


/*
 * build the UI here
 */
void do_main_winloop(void)
{
    Widget bt, rc3, rcleft, rctop, formbot;
    Pixmap icon;
    XSetWindowAttributes sw;

    main_frame = XtVaCreateManagedWidget("main", xmMainWindowWidgetClass, app_shell,
					 XmNshadowThickness, 0,
					 XmNwidth, 800,
					 XmNheight, 700,
					 NULL);

    XtAddCallback(main_frame, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_MAIN);

    menu_bar = CreateMenuBar(main_frame);
    XtManageChild(menu_bar);

    form = XmCreateForm(main_frame, "form", NULL, 0);

    frleft = XtVaCreateManagedWidget("fr", xmFrameWidgetClass, form,
				     NULL);
    rcleft = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, frleft,
				     XmNorientation, XmVERTICAL,
				     XmNpacking, XmPACK_TIGHT,
				     XmNspacing, 0,
				     XmNentryBorder, 0,
				     XmNmarginWidth, 0,
				     XmNmarginHeight, 0,
				     NULL);
    XtAddCallback(rcleft, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR);

    frtop = XtVaCreateManagedWidget("frtop", xmFrameWidgetClass, form,
				    NULL);
    rctop = XtVaCreateManagedWidget("rctop", xmRowColumnWidgetClass, frtop,
				    XmNorientation, XmHORIZONTAL,
				    XmNpacking, XmPACK_TIGHT,
				    XmNspacing, 0,
				    XmNentryBorder, 0,
				    XmNmarginWidth, 0,
				    XmNmarginHeight, 0,
				    NULL);

    frbot = XtVaCreateManagedWidget("frbot", xmFrameWidgetClass, form, NULL);
    XtManageChild(frbot);
    /* formbot = XmCreateForm(frbot, "form", NULL, 0); */
    formbot = XmCreateRowColumn(frbot, "rc", NULL, 0);
    set_default_message(buf);
    statstring = XmStringCreateLtoR(buf, charset);
    statlab = XtVaCreateManagedWidget("statlab", xmLabelWidgetClass, formbot,
				      XmNlabelString, statstring,
				      XmNalignment, XmALIGNMENT_BEGINNING,
				      XmNrecomputeSize, True,
				      NULL);
    XtAddCallback(statlab, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_STATBAR);

    string = XmStringCreateLtoR("G0:[X, Y] =                                           ",
				charset);
    loclab = XtVaCreateManagedWidget("label Locate", xmLabelWidgetClass, rctop,
				     XmNlabelString, string,
				     XmNalignment, XmALIGNMENT_END,
				     XmNrecomputeSize, True,
				     NULL);
    XtAddCallback(loclab, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_LOCBAR);

    XtManageChild(formbot);

    scrollw = XtVaCreateManagedWidget("scrollw",
				      xmScrolledWindowWidgetClass, form,
				XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
				      XmNscrollingPolicy, XmAUTOMATIC,
				      XmNvisualPolicy, XmVARIABLE,
				      NULL);

    canvas = XtVaCreateManagedWidget("canvas", xmDrawingAreaWidgetClass, scrollw,
				     XmNwidth, (Dimension) canvasw,
				     XmNheight, (Dimension) canvash,
				     XmNbackground,
				     WhitePixel(XtDisplay(main_frame),
				   DefaultScreen(XtDisplay(main_frame))),
				     NULL);
    XtAddCallback(canvas, XmNexposeCallback, (XtCallbackProc) refresh, NULL);
    XtAddCallback(canvas, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_CANVAS);


    XtAddEventHandler(canvas, EnterWindowMask
		      | LeaveWindowMask
		      | ButtonPressMask
		      | PointerMotionMask
		      | KeyPressMask
		      | ColormapChangeMask,
		      FALSE,
		      (XtEventHandler) my_proc, NULL);

    XtVaSetValues(frleft,
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, frtop,
		  XmNbottomAttachment, XmATTACH_WIDGET,
		  XmNbottomWidget, frbot,
		  XmNleftAttachment, XmATTACH_FORM,
		  NULL);
    XtVaSetValues(frtop,
		  XmNtopAttachment, XmATTACH_FORM,
		  XmNleftAttachment, XmATTACH_FORM,
		  XmNrightAttachment, XmATTACH_FORM,
		  NULL);
    XtVaSetValues(scrollw,
		  XmNtopAttachment, XmATTACH_WIDGET,
		  XmNtopWidget, frtop,
		  XmNbottomAttachment, XmATTACH_WIDGET,
		  XmNbottomWidget, frbot,
		  XmNrightAttachment, XmATTACH_FORM,
		  XmNleftAttachment, XmATTACH_WIDGET,
		  XmNleftWidget, frleft,
		  NULL);
    XtVaSetValues(frbot,
		  XmNbottomAttachment, XmATTACH_FORM,
		  XmNrightAttachment, XmATTACH_FORM,
		  XmNleftAttachment, XmATTACH_FORM,
		  NULL);

    XtManageChild(form);

/*
 * initialize pixmaps for buttons on front
 */
    init_pm();

    bt = XtVaCreateManagedWidget("Draw", xmPushButtonWidgetClass, rcleft,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) doforce_redraw, (XtPointer) NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_DRAW);

/* zoom and autoscale */
    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("Zoom", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, zoompm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) set_actioncb, (XtPointer) ZOOM_1ST);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_ZOOM);

    bt = XtVaCreateManagedWidget("AS", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, autopm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) autoscale_proc, (XtPointer) 0);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_AS);

/* expand/shrink */
    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("Z", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, expandpm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwindshrink_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_SHRINK);

    bt = XtVaCreateManagedWidget("z", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, shrinkpm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwindexpand_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_EXPAND);

/*
 * scrolling buttons
 */
    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("Left", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, leftpm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwindleft_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_LEFT);

    bt = XtVaCreateManagedWidget("Right", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, rightpm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwindright_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_RIGHT);

    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);

    bt = XtVaCreateManagedWidget("Down", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, downpm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwinddown_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_DOWN);
    
    bt = XtVaCreateManagedWidget("Up", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtVaSetValues(bt,
		  XmNlabelType, XmPIXMAP,
		  XmNlabelPixmap, uppm,
		  NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) gwindup_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_UP);

    XtVaCreateManagedWidget("sep", xmSeparatorWidgetClass, rcleft,
			    NULL);

/* TODO
    abort_button = XtVaCreateManagedWidget("Abort", xmPushButtonWidgetClass, rcleft,
					   XmNsensitive, False,
					   NULL);
    XtAddCallback(abort_button, XmNactivateCallback, (XtCallbackProc) do_abort, NULL);
    abort_win = XtWindow(abort_button);
*/

    bt = XtVaCreateManagedWidget("AutoT", xmPushButtonWidgetClass, rcleft,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) autoticks_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_AUTOTICKS);

    bt = XtVaCreateManagedWidget("AutoO", xmPushButtonWidgetClass, rcleft,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) autoon_proc, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_AUTOON);

    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("ZX", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) set_actioncb, (XtPointer) ZOOMX_1ST);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_ZOOMX);

    bt = XtVaCreateManagedWidget("ZY", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) set_actioncb, (XtPointer) ZOOMY_1ST);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_ZOOMY);

    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("AX", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) autoscale_proc, (XtPointer) 1);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_AUTOX);

    bt = XtVaCreateManagedWidget("AY", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) autoscale_proc, (XtPointer) 2);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_AUTOY);

    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("PZ", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) push_and_zoom, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_PZ);

    bt = XtVaCreateManagedWidget("Pu", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) push_world, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_PU);

    rc3 = XtVaCreateManagedWidget("rc", xmRowColumnWidgetClass, rcleft,
				  XmNorientation, XmHORIZONTAL,
				  XmNpacking, XmPACK_TIGHT,
				  XmNspacing, 0,
				  XmNentryBorder, 0,
				  XmNmarginWidth, 0,
				  XmNmarginHeight, 0,
				  NULL);
    bt = XtVaCreateManagedWidget("Po", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) pop_world, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_PO);

    bt = XtVaCreateManagedWidget("Cy", xmPushButtonWidgetClass, rc3,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) cycle_world_stack, NULL);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_CY);

    sdstring = XmStringCreateLtoR("SD:0 ", charset);
    stack_depth_item = XtVaCreateManagedWidget("stackdepth", xmLabelWidgetClass, rcleft,
					       XmNlabelString, sdstring,
					       NULL);
    XtAddCallback(stack_depth_item, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_SD);

    cystring = XmStringCreateLtoR("CW:0 ", charset);
    curw_item = XtVaCreateManagedWidget("curworld", xmLabelWidgetClass, rcleft,
					XmNlabelString, cystring,
					NULL);
    XtAddCallback(curw_item, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_CW);

    bt = XtVaCreateManagedWidget("Exit", xmPushButtonWidgetClass, rcleft,
				 NULL);
    XtAddCallback(bt, XmNactivateCallback, (XtCallbackProc) MenuCB, (XtPointer) MENU_EXIT);
    XtAddCallback(bt, XmNhelpCallback, (XtCallbackProc) HelpCB, (XtPointer) HELP_TOOLBAR_EXIT);


/*
 * initialize the tool bars
 */
    set_view_items();

    XmMainWindowSetAreas(main_frame, menu_bar, NULL, NULL, NULL, form);
    XtRealizeWidget(app_shell);

    xwin = XtWindow(canvas);
    disp = XtDisplay(canvas);

    sw.backing_store = Always;
    XChangeWindowAttributes(disp, xwin, CWBackingStore, &sw);

    set_page(NULL, (XtPointer) page_layout, NULL);

    XtAddCallback(canvas, XmNresizeCallback, (XtCallbackProc) refresh, (XtPointer) 1);

/*
 * A named pipe
 */
    if (named_pipe) {
	set_pipetimer();
    }
/*
 * set colors
 */
    xlibinitcmap();
    if (use_colors > 2) {
	XtVaSetValues(canvas, XmNcolormap, mycmap, NULL);
	XSetWindowColormap(disp, xwin, mycmap);
    }
/*
 * set GCs
 */
    gc = DefaultGC(disp, DefaultScreen(disp));
    gc_val.foreground = WhitePixel(disp, DefaultScreen(disp));
    gc_val.foreground = BlackPixel(disp, DefaultScreen(disp)) ^ WhitePixel(disp, DefaultScreen(disp));
    if (invert) {
	gc_val.function = GXinvert;
    } else {
	gc_val.function = GXxor;
    }
    gcxor = XCreateGC(disp, xwin, GCFunction | GCForeground, &gc_val);
    gc_val.foreground = WhitePixel(disp, DefaultScreen(disp));
    gc_val.function = GXcopy;
    gcclr = XCreateGC(disp, xwin, GCFunction | GCForeground, &gc_val);

    icon = XCreateBitmapFromData(XtDisplay(app_shell),
				 DefaultRootWindow(XtDisplay(app_shell)),
				 (char *) xmgr_icon_bits, xmgr_icon_width,
				 xmgr_icon_height);
    XtVaSetValues(app_shell,
		  XtNiconPixmap, icon,
		  XtNiconMask, icon,
		  NULL);

    /*
     * initialize cursors
     */
    init_cursors();

    /*
     * if an image was placed on the command line, read it in
     */
    if (readimage) {
	read_image(image_filename);
    }
    /*
     * If logging is on, initialize
     */
    inwin = 1;
    log_results("Startup");
    inwin = 0;

    /*
     * set the title to the working directory
     */
    set_title(mybasename(docname));

#ifdef DRAGnDROP
    /*
     * initialize drag n drop
     */
    init_dragndrop();
#endif

    /*
     * Process events.
     */
    XtAppMainLoop(app_con);
}

/*
 * initialize pixmaps for buttons on front
 */
static void init_pm(void)
{
    Display *disp = XtDisplay(app_shell);
    Window cwin = RootWindowOfScreen(XtScreen(app_shell));
    GC gc;
    Pixmap ptmp;
    Pixel fg, bg;

    XtVaGetValues(menu_bar,
		  XmNforeground, &fg,
		  XmNbackground, &bg,
		  NULL);

    gc = XCreateGC(disp, cwin, 0, NULL);
    XSetForeground(disp, gc, fg);
    XSetBackground(disp, gc, bg);

    zoompm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) zoom_bits, 16, 16);
    XCopyPlane(disp, ptmp, zoompm, gc, 0, 0, 16, 16, 0, 0, 1);
    autopm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) auto_bits, 16, 16);
    XCopyPlane(disp, ptmp, autopm, gc, 0, 0, 16, 16, 0, 0, 1);
    shrinkpm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) shrink_bits, 16, 16);
    XCopyPlane(disp, ptmp, shrinkpm, gc, 0, 0, 16, 16, 0, 0, 1);
    expandpm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) expand_bits, 16, 16);
    XCopyPlane(disp, ptmp, expandpm, gc, 0, 0, 16, 16, 0, 0, 1);
    rightpm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) right_bits, 16, 16);
    XCopyPlane(disp, ptmp, rightpm, gc, 0, 0, 16, 16, 0, 0, 1);
    leftpm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) left_bits, 16, 16);
    XCopyPlane(disp, ptmp, leftpm, gc, 0, 0, 16, 16, 0, 0, 1);
    uppm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) up_bits, 16, 16);
    XCopyPlane(disp, ptmp, uppm, gc, 0, 0, 16, 16, 0, 0, 1);
    downpm = XCreatePixmap(disp, cwin, 16, 16, DisplayPlanes(disp, DefaultScreen(disp)));
    ptmp = XCreateBitmapFromData(disp, cwin, (char *) down_bits, 16, 16);
    XCopyPlane(disp, ptmp, downpm, gc, 0, 0, 16, 16, 0, 0, 1);
}

/* Routine for named pipes */

static int fid;
static XtInputId iid;
static XtIntervalId tim;
static XtInputCallbackProc get_file_input(XtPointer cd, int *src, XtInputId * iid);
static XtTimerCallbackProc timercb(XtPointer cdp, XtIntervalId * id);

static void set_pipetimer(void)
{
    tim = XtAppAddTimeOut(app_con, timer_delay, (XtTimerCallbackProc) timercb, NULL);
}

static XtTimerCallbackProc timercb(XtPointer cdp, XtIntervalId * id)
{
    static int opflag = 0;
    opflag = opflag ? 0 : 1;
    if (opflag) {
	fid = open(pipe_name, O_NONBLOCK | O_RDONLY);	/* POSIX nonblocking io */
/*
        fid = open(pipe_name, O_NDELAY | O_RDONLY);
*/
	if (fid < 0) {
	    perror("Can't open fifo");
	    named_pipe = 0;
	} else {
	    named_pipe = 1;
	    iid = XtAppAddInput(app_con, fid,
				(XtPointer) XtInputReadMask,
				(XtInputCallbackProc) get_file_input,
				NULL);
	}
    } else {
	close(fid);
	XtRemoveInput(iid);
    }
    if (named_pipe) {
	tim = XtAppAddTimeOut(app_con, timer_delay, (XtTimerCallbackProc) timercb, NULL);
    }
    return (XtTimerCallbackProc) NULL;
}

/*
 * Read from named pipe
 */
static XtInputCallbackProc get_file_input(XtPointer cd, int *fid, XtInputId * id)
{
    char buf[BUFSIZ];
    int nb;
    char *s;

    s = buf;
    while ((nb = read(*fid, s, 1)) > 0) {
	if (*s == '\n') {
	    *(s + 1) = 0;
	    exec_cmd(buf);
	    s = buf;
	} else
	    s++;
    }
    if (nb == -1 && errno != EAGAIN) {
	perror("get_file_input");
    }
    return (XtInputCallbackProc) NULL;
}

#ifdef DRAGnDROP
/* HandleDropLabel() -- start the data transfer when data is dropped in
 * the filename status area.
 */
void HandleDropLabel(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{

    Display *dpy;
    Atom FILE_CONTENTS, FILE_NAME;
    XmDropProcCallback DropData;
    XmDropTransferEntryRec transferEntries[2];
    XmDropTransferEntry transferList;
    Arg args[10];
    int n, i;
    Widget dc;
    Cardinal numExportTargets;
    Atom *exportTargets;
    Boolean file_name = False;
    void TransferProc();

    /* intern the Atoms for data targets */
    dpy = XtDisplay(app_shell);
    FILE_CONTENTS = XmInternAtom(dpy, "FILE_CONTENTS", False);
    FILE_NAME = XmInternAtom(dpy, "FILE_NAME", False);

    DropData = (XmDropProcCallback) call_data;
    dc = DropData->dragContext;

    /* retrieve the data targets and search for FILE_NAME */
    n = 0;
    XtSetArg(args[n], XmNexportTargets, &exportTargets);
    n++;
    XtSetArg(args[n], XmNnumExportTargets, &numExportTargets);
    n++;
    XtGetValues(dc, args, n);

    for (i = 0; i < numExportTargets; i++) {
	printf("In drop label %d\n", exportTargets[i]);
	if (exportTargets[i] == FILE_CONTENTS) {
	    file_name = True;
	    break;
	}
    }

    /* make sure we have a drop that is a copy operation and one of
     * the targets is FILE_NAME.  if not, set the status to failure.
     */
    n = 0;
    printf("In drop label success\n");
    /* set up transfer requests for drop site */
    transferEntries[0].target = FILE_CONTENTS;
    transferEntries[0].client_data = (XtPointer) canvas;
    transferEntries[1].target = FILE_NAME;
    transferEntries[1].client_data = (XtPointer) canvas;
    transferList = transferEntries;
    XtSetArg(args[n], XmNdropTransfers, transferEntries);
    n++;
    XtSetArg(args[n], XmNnumDropTransfers,
	     XtNumber(transferEntries));
    n++;
    XtSetArg(args[n], XmNtransferProc, TransferProc);
    n++;
    XmDropTransferStart(dc, args, n);
    return;
    if ((!file_name) || (DropData->dropAction != XmDROP) ||
	(DropData->operation != XmDROP_COPY)) {
	XtSetArg(args[n], XmNtransferStatus, XmTRANSFER_FAILURE);
	n++;
	XtSetArg(args[n], XmNnumDropTransfers, 0);
	n++;
	printf("In drop label failure\n");
    } else {
	printf("In drop label success\n");
	/* set up transfer requests for drop site */
	transferEntries[0].target = FILE_CONTENTS;
	transferEntries[0].client_data = (XtPointer) canvas;
	transferEntries[1].target = FILE_NAME;
	transferEntries[1].client_data = (XtPointer) canvas;
	transferList = transferEntries;
	XtSetArg(args[n], XmNdropTransfers, transferEntries);
	n++;
	XtSetArg(args[n], XmNnumDropTransfers,
		 XtNumber(transferEntries));
	n++;
	XtSetArg(args[n], XmNtransferProc, TransferProc);
	n++;
    }
    XmDropTransferStart(dc, args, n);
}

/* TransferProc() -- handle data transfer of converted data from drag
 * source to drop site.
 */
void TransferProc(widget, client_data, seltype, type, value, length, format)
Widget widget;
XtPointer client_data;
Atom *seltype;
Atom *type;
XtPointer value;
unsigned long *length;
int format;
{
    Display *dpy;
    Atom FILE_CONTENTS, FILE_NAME;
    Widget w;
    XmString string;
    char *label[256];

    /* intern the Atoms for data targets */
    dpy = XtDisplay(app_shell);
    FILE_CONTENTS = XmInternAtom(dpy, "FILE_CONTENTS", False);
    FILE_NAME = XmInternAtom(dpy, "FILE_NAME", False);

    w = (Widget) client_data;

    printf("In transfer proc\n");
    printf("Contents = %s\n", value);
    if (*type == FILE_CONTENTS)
	printf("Contents = %s\n", value);
/*
        XmTextSetString (w, value);
*/
    else if (*type == FILE_NAME) {
	printf("Filename: %s", value);
/*
        sprintf (label, "Filename: %s", value);
        string = XmStringCreateLocalized (label);
        XtVaSetValues (w, XmNlabelString, string, NULL);
        XmStringFree (string);
*/
    }
}

void init_dragndrop(void)
{
    Arg args[10];
    int n;

    n = 0;
    importList[0] = FILE_CONTENTS;
    importList[1] = FILE_NAME;
    XtSetArg(args[n], XmNimportTargets, importList);
    n++;
    XtSetArg(args[n], XmNnumImportTargets, 2);
    n++;
    XtSetArg(args[n], XmNdropSiteOperations, XmDROP_COPY);
    n++;
    XtSetArg(args[n], XmNdropProc, HandleDropLabel);
    n++;
    XmDropSiteRegister(canvas, args, n);
}

#endif
