/* vms_unix.c */
/* Rolf Niepraschk, 1/97, niepraschk@ptb.de */

#include <string.h>

/* some suggestions comes from the gawk VMS port -- R.N. */

#include <stdlib.h>
#include <stdio.h>
#include <lib$routines.h>
#include <descrip.h>
#include <clidef.h>
#include <errno.h>

#define	emalloc(var,ty,x,str) (void)((var=(ty)malloc((size_t)(x))) ||\
		(fprintf(stderr, "%s: %s: can't allocate memory (%s)",\
					(str), #var, strerror(errno)),0))

/* this is a "system" function for VMS because 
   system("spawn/nowait mosaic ...") dosn't work -- why not? -- RN */
int system_spawn(const char *command)
{
  $DESCRIPTOR(dstr, ""); int retval;
  
  dstr.dsc$a_pointer = malloc(1024);
  strcpy(dstr.dsc$a_pointer, command);
  dstr.dsc$w_length = strlen(dstr.dsc$a_pointer);

  retval = lib$spawn(&dstr, 0, 0, &CLI$M_NOWAIT); 
  
  free(dstr.dsc$a_pointer);
  
  return retval; 
}

#if __VMS_VER < 70000000 
  char *strdup(const char *str)
  {
    char *result;
    int len = strlen(str);

    emalloc(result, char *, len+1, "strdup");
    return strcpy(result, str);
  }
#endif
