/*****
This file is part of the Babel Program
Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
The Babel Program is a product of the Dolata Research Group
Dept. of Chemistry
University of Arizona
Tucson, AZ 85721

For more information please contact :

babel@mercury.aichem.arizona.edu
--------------------------------------------------------------------------------

FILE : bbl_types.h
AUTHOR(S) : Pat Walters
DATE : Constantly evolving

******/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include "bblmacs.h"


enum file_type {
  none, mopac_cartesian, mopac_internal, mopac_output, macromodel, 
  m3d, mm2_output, pdb, csd_gstat, xyz, chemdraw, 
  idatm, mm2_input, alchemy, csd_cssr, free_fract,
  mac_molecule, report, amber_prep, molin, boogie, 
  caccrt, ball_and_stick, chem3d1, chem3d2, micro_world, 
  molfile, gamess_output, gamess_input, mmads, diagnostics, 
  shelx, csd_fdat, charmm, gaussian_output, 
  gaussian_input, gaussian_cart, hyperchem_hin, biosym_car, cadpac,
  cache_out, mm3, sybyl_mol, sybyl_mol2, spartan, quanta, molgen, wizard,
  feature, pcmodel, spart_semi, cacao_int, fenske_zmat,spart_mm,
  gaussian_template,bmin_com, conjure_tmplt, icon8, maccs, maccs2d,
  maccs3d, xed, unixyz, isis, ampac_output
  };

enum op_type {noaction,input, output};

enum type_err {zero, dummy, all_caps};

typedef char char3[3];

typedef struct
{
  enum file_type type;
  char *type_name;
  char *code;
  enum op_type operation;
  int (*func)();
} babel_rec;


typedef struct
{
  int a,b,c,d;
} torsion_rec;

typedef struct
{
  int a,b,c;
} angle_rec;

typedef struct 
{
  int number;
  char name[3];
  double cov_rad;
  double bond_ord_rad;
  double vdw_rad;
  double bs_rad;
  int max_bonds;
  int color;
  double red;
  double green;
  double blue;
} element_type;

typedef struct 
{
  double x,y,z;
} coord_type;


typedef struct 
{
  coord_type point;
  char type[5];
  int max_bonds;
  int valence;
  int connected_atoms[MAX_CONNECTIONS];
  int bond_order[MAX_CONNECTIONS];
  double radius;
  double bond_ord_rad;
  double dble;
  int organic;
  int redo;
  int pos[3];
  double charge;
} atom_type;


typedef struct 
{
  int start;
  int end;
  int bond_order;
} connect_type;

typedef struct 
{
  double r;
  double w;
  double t;
/*  int  n; */
  int  na;
  int  nb;
  int  nc;
} int_type;

typedef struct
{
  char default_extension[BUFF_SIZE];
  char base_name[BUFF_SIZE];
  char infile_name[BUFF_SIZE];
  char outfile_name[BUFF_SIZE];
  char input_keywords[BUFF_SIZE];
  char output_keywords[BUFF_SIZE];
  char del_str[BUFF_SIZE];
  babel_rec input_info;
  babel_rec output_info;
  int verbose;
  int use_menus;
  int do_add_hydrogens;
  int do_delete_atoms;
  int the_size;
  int multi;
  int lower_limit;
  int upper_limit;
  int spline;
  int increment;
  int renum;
  int new_base;
  int center;
  int align;
} bbl_control;


/*************
HUGEPTR as defined in the struct below is a maco
which defines HUGEPTR as the keyword huge when #define MSDOS
is present or as nothing when #define MSDOS is absent.  This is 
necessary because of the lovely method Intel uses to segment memory.

The macros are defined in bblmacs.h
PW - 072094
****************/

typedef struct
{
  double A,B,C;
  double Alpha,Beta,Gamma;
} fract_type;

typedef struct
{
  int chain_num;
  int res_num;
  char res_type[6];
  char atm_type[6];
} res_list;

struct ums
{
  bbl_control *control;
  char default_extension[20];
  int num_atoms;
  int num_bonds;
  char title[200];
  double energy;
  res_list *residues;
  atom_type HUGEPTR *atoms;
  connect_type HUGEPTR *connections;
  int_type HUGEPTR *internal;
  fract_type *fract;
  struct ums *next;
};
typedef struct ums ums_type;

typedef struct 
{
  int atom_number;
  int heavy_atoms;
} heavy_rec;

typedef struct 
{
  char name[8];
  int number;
} pdb_type_rec;


typedef struct
{
  char *text;
  enum file_type type;
  int keywords_required;
} menu_type;


typedef struct
{
  double x,y,z;
} vect_type;


typedef struct
{
  double a1, b1, c1;
  double a2, b2, c2;
  double a3, b3, c3;
} matrix_3x3;


typedef struct
{
  double x;
  double y;
  double z;
  int num;
  double dist;
} temp_atom_rec;

typedef char warning[80];

typedef struct 
{
  char sym[10];
  double val;
} zsymbol;

typedef struct
{
  int level;
  int ancestor;
  int kids;
  int kid[MAX_CONNECTIONS];
} z_tree;

#include "babel.h"
