/*****
  This file is part of the Babel Program
  Copyright (C) 1992-94 W. Patrick Walters and Matthew T. Stahl
  The Babel Program is a product of the Dolata Research Group
  Dept. of Chemistry
  University of Arizona
  Tucson, AZ 85721
  
  For more information please contact :
  
  babel@mercury.aichem.arizona.edu
  ----------------------------------------------------------------------------
  FILE : rdm3d.c
  AUTHOR(S) : originally Pat Walters, modified by Will Ware
  DATE : 11-96
  PURPOSE : routines to read a Molecular Arts M3D file
  ******/

#include "bbltyp.h"

int read_m3d(FILE *file1, ums_type *mol)
{
  int i;
  int start,end;
  char input_line[BUFF_SIZE];
  char temp_type[5];
  char bo_string[10];
  
  /* for now, throw away the first line */
  fgets(input_line,sizeof(input_line),file1);

  fgets(input_line,sizeof(input_line),file1);
  sscanf(input_line,"%d %d",
	 &Atoms,
	 &Bonds);

  ShowProgress(Atoms,"Reading Atoms");
  initialize_ums(&mol);
  for (i = 1; i <= Atoms; i ++)
  {
    UpdateProgress();
    fgets(input_line,sizeof(input_line),file1);
    sscanf(input_line,"%*d %s %*d %lf %lf %lf",
	   temp_type,
	   &X(i),
	   &Y(i),
	   &Z(i));
    get_input_type(i,"XYZ",temp_type,Type(i),dummy);
  }
  for (i = 0; i < Bonds; i++)
  {
    fgets(input_line,sizeof(input_line),file1);
    sscanf(input_line,"%*d%d%d%s",&Start(i),&End(i),bo_string);
    Bond_order(i) = translate_m3d_bond_order(bo_string);
  }
  dissect_connection_table(mol);
  return(TRUE);
}

int translate_m3d_bond_order(char *bo_string)
{
  char err_string[50];
  
  if (EQ(bo_string,"SINGLE") || EQ(bo_string,"Single"))
    return(1);
  if (EQ(bo_string,"DOUBLE") || EQ(bo_string,"Double"))
    return(2);
  if (EQ(bo_string,"TRIPLE") || EQ(bo_string,"Triple"))
    return(3);
  if (EQ(bo_string,"AROMATIC") || EQ(bo_string,"Aromatic"))
    return(5);
  sprintf(err_string,"No bond type for M3D label %s",bo_string);
  return(1);
}



