/* =======================================================================
    C50LIB.H - Library of routines for building TMS320C50 simulators
    Copyright (C) 1996 Will Ware

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ======================================================================= */

typedef struct sGLOB
    {
    char name[40];
    int value;
    struct sGLOB *next;
    } symbol;

typedef unsigned int uint;
typedef int (*iufunc) (uint);

/* Interrupt types */
enum int_type { RS, INT0, INT1, INT2, TINT, RINT, XINT, TRAP };

extern int arp, ov, ovm, intm, dp;
extern int arb, cnf, tc, sxm, c, hm, fsm, xf, fo, txm, pm;
extern long int accumulator, p_register;
extern unsigned int pc;
extern int t_register, _stack[8], _sp, ar[8];
extern int mp_mc_mode;
extern int ports[16], bio;
extern int drr, dxr, tim, prd, imr, greg;

extern unsigned long int steps_taken, cycles;

extern char error_string[100];

/* ======================================================================= */
/*                           Public Functions                              */
/* ======================================================================= */

extern void c50_reset (void);
extern void c50_interrupt (enum int_type n);
extern char * disassemble (int instruc);
extern void advance (void);

extern void write_program_memory (uint address, int data);
extern int read_program_memory (uint address);
extern void write_data_memory (uint address, int data);
extern int read_data_memory (uint address);

/* We expect the user to define off-chip-memory writes and reads to program
 * and data memory, by providing these functions for us. We also expect the
 * user to define how warnings and errors are handled.
 */

extern void write_program_off_chip (uint address, int data);
extern int  read_program_off_chip  (uint address);
extern void write_data_off_chip (uint address, int data);
extern int  read_data_off_chip  (uint address);
extern void write_io_port (uint address, int data);
extern int  read_io_port  (uint address);

extern void handle_error(void);

