/* This is a quickly-hacked-together test of some of the stuff in
 * c50lib.c. The idea is to test the things I'm least certain about.
 * At the moment, those are:
 *
 *   Branches, Interrupts, Pipeline Operation, Cycle Timing
 *
 * and also general stuff, i.e. did I get *any* of it right?
 */

#include <stdio.h>
#include <stdlib.h>
#include "c50lib.h"

typedef void (*voidfunc) (void);

enum PHASE
  {
    FETCH = 0, DECODE = 1, OPERAND = 2, EXECUTE = 3
  };

typedef struct
  {
    char valid;
    int instruction;
    voidfunc f;
    uint operand_address, spare_arg;
    long int operand, old_accum;
  }
pipeline_layer;

extern pipeline_layer pipeline[4];

/****** First, define off-chip memory. ********/

#define ROMSIZE 0x2000
#define RAMSIZE 0x8000
#define RAMSTART ((unsigned long) 0x8000)
int program_rom[ROMSIZE], data_ram[RAMSIZE];

void
write_program_off_chip (uint address, int data)
{
  printf ("Trying to write program memory at 0x%04X\n", address);
}

int
read_program_off_chip (uint address)
{
  if (address < ROMSIZE)
    return program_rom[address];
  printf ("Trying to read program memory at 0x%04X\n", address);
  return 0;
}

void
write_data_off_chip (uint address, int data)
{
  if (address < RAMSTART)
    printf("Trying to write off-chip data memory at %04X\n", address);
  else if (address < RAMSTART + RAMSIZE)
    data_ram[address] = data;
  else
    printf("Trying to write off-chip data memory at %04X\n", address);
}

int
read_data_off_chip (uint address)
{
  if (address < RAMSTART)
    printf("Trying to read off-chip data memory at %04X\n", address);
  else if (address < RAMSTART + RAMSIZE)
    return data_ram[address];
  else
    printf("Trying to read off-chip data memory at %04X\n", address);
  return 0;
}

void
handle_error (void)
{
  fprintf (stderr, "%s\n", error_string);
  /* exit (1); */
}

void
write_io_port (uint a, int d)
{
}

int
read_io_port (uint a)
{
  return 0;
}

void
step_with_printout (int newline)
{
  uint x = pc;

  advance ();
  printf ("%04X %04X %-6s %-6s %-6s %-6s",
	  x,
	  pipeline[FETCH].instruction,
	  pipeline[FETCH].valid ?
	  disassemble(pipeline[FETCH].instruction) : "---   ",
	  pipeline[DECODE].valid ?
	  disassemble(pipeline[DECODE].instruction) : "---   ",
	  pipeline[OPERAND].valid ?
	  disassemble(pipeline[OPERAND].instruction) : "---   ",
	  pipeline[EXECUTE].valid ?
	  disassemble(pipeline[EXECUTE].instruction) : "---   ");
  if (newline)
    printf("\n");
}
