/* This is a quickly-hacked-together test of some of the stuff in
 * c50lib.c. The idea is to test the things I'm least certain about.
 * At the moment, those are:
 *
 *   Branches, Interrupts, Pipeline Operation, Cycle Timing
 *
 * and also general stuff, i.e. did I get *any* of it right?
 */

#include <stdio.h>
#include <stdlib.h>
#include "c50lib.h"

extern int program_rom[];

#define LACL     0xB900
#define CALL     0x7A80
#define CALLD    0x7E80
#define RET      0xEF00
#define RETD     0xFF00
#define NOP      0x8B00
#define LAR2     0xB200     /* lar ar2 short-immediate */
#define SAMM     0x8812     /* samm ar2 */
#define LACCM    0x1090     /* lacc *- */
#define ADDM     0x2090     /* add *- */

#define NEXT(n) program_rom[i++] = (n)

extern void step_with_printout (int newline);

void main(void)
{
  int i, j;
  uint x;

  c50_reset ();
  mp_mc_mode = 1;

  /* EXAM1 from TI book */
  i = 0;
  NEXT (LAR2 + 0x67);
  NEXT (LACL + 0x64);
  NEXT (SAMM);
  NEXT (LACCM);
  NEXT (ADDM);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);
  NEXT (NOP);

  arp = 2;
  for (i = 0; i < 15; i++)
    {
      step_with_printout (0);
      printf ("%08X %04X\n", accumulator, ar[2]);
    }
}
