;; This is a performance test to see why Common Lisp is running so much
;; slower than Scheme. The slowdown appears to be in the fill-diff-dist-table
;; routine.

(if (not (defined? 'atom-list))
    (load "ncad021.scm"))

(define (propane)
  (clear-structure)
  (add-atom "C" '#(-1.6192231896357 0.10913828710019 0.059089635045815))
  (add-atom "C" '#(0.057508530150221 -0.59251320772937 0.057957421682237))
  (add-atom "C" '#(1.5614160525151 0.42533696428484 -0.11545370543238))
  (add-atom "H" '#(-2.4286228415902 -0.78350252298058 -0.4367304383663))
  (add-atom "H" '#(-1.6275048913605 1.1771713105404 -0.64271318143432))
  (add-atom "H" '#(-1.9450207470767 0.33650493105546 1.2919456677319))
  (add-atom "H" '#(0.18595554441562 -1.1546247770247 1.1821974294535))
  (add-atom "H" '#(0.088500477802441 -1.3735084054718 -0.94323432063565))
  (add-atom "H" '#(1.7674216822209 1.0546257613843 0.98788251635771))
  (add-atom "H" '#(2.5279590432339 -0.41575445499099 -0.32991347593932))
  (add-atom "H" '#(1.4316103393248 1.2171261138323 -1.1110275484632))
  (add-bond 1 2 8)
  (add-bond 1 9 2)
  (add-bond 1 2 10)
  (add-bond 1 7 1)
  (add-bond 1 1 6)
  (add-bond 1 1 2)
  (add-bond 1 0 1)
  (add-bond 1 0 3)
  (add-bond 1 4 0)
  (add-bond 1 5 0))

(propane)
(setup-terms)

; -------------------------------

(define (test1)
  (do ((L1 atom-list (cdr L1)))
      ((null? L1))
    (do ((L2 atom-list (cdr L2)))
        ((null? L2))
	false)))


; -------------------------------

(define (test1a)
  (do ((L1 atom-list (cdr L1))
       (i 0 (+ i 1)))
      ((null? L1))
    (do ((L2 atom-list (cdr L2))
         (j 0 (+ j 1)))
        ((null? L2))
	false)))


; -------------------------------

(define (test2)
  (do ((L1 atom-list (cdr L1))
       (i 0 (+ i 1)))
      ((null? L1))
    (do ((L2 atom-list (cdr L2))
         (j 0 (+ j 1)))
        ((null? L2))
	(create-diff-dist (car L2) (car L1)))))


; -------------------------------

(define (test3)
  (do ((L1 atom-list (cdr L1))
       (i 0 (+ i 1)))
      ((null? L1))
    (do ((L2 atom-list (cdr L2))
         (j 0 (+ j 1)))
        ((null? L2))
	(let ((d (vdiff (atm-position (car L1))
			(atm-position (car L2)))))
	  (vlen d)))))


; -------------------------------

(define (test4)
  (do ((L1 atom-list (cdr L1))
       (i 0 (+ i 1)))
      ((null? L1))
    (do ((L2 atom-list (cdr L2))
         (j 0 (+ j 1)))
        ((null? L2))
	(vdiff (atm-position (car L1))
	       (atm-position (car L2))))))


; -------------------------------

;	What can we conclude from all this:

;	It's apparent that the vast majority of GCL's time is spent
;	in "vdiff" and "vlen". Neither of these are horribly written
;	functions, so there's probably no way to do much better with GCL.

;	Apparently, MzScheme just has a much better implementation
;	of floating-point math than GCL.

; -------------------------------

(define n 100)

(printf "~%~%Time for fill-diff-dist-table~%")
(time (dotimes (i n) (fill-diff-dist-table)))
(printf "~%~%Time for test1~%")
(time (dotimes (i n) (test1)))
(printf "~%~%Time for test1a~%")
(time (dotimes (i n) (test1a)))
(printf "~%~%Time for test2~%")
(time (dotimes (i n) (test2)))
(printf "~%~%Time for test3~%")
(time (dotimes (i n) (test3)))
(printf "~%~%Time for test4~%")
(time (dotimes (i n) (test4)))


#|
All times are on a 133 MHz Cyrix 6x86 with 16 MB of RAM running Linux

------------------------------

CLISP, the 1996-07-22 release:

Time for fill-diff-dist-table

Real time: 1.966721 sec.
Run time: 1.84 sec.
Space: 499612 Bytes
GC: 1, GC time: 0.07 sec.

Time for test1

Real time: 0.094603 sec.
Run time: 0.09 sec.
Space: 652 Bytes

Time for test1a

Real time: 0.244825 sec.
Run time: 0.13 sec.
Space: 652 Bytes

Time for test2

Real time: 1.871676 sec.
Run time: 1.77 sec.
Space: 499612 Bytes
GC: 1, GC time: 0.07 sec.

Time for test3

Real time: 1.294755 sec.
Run time: 1.29 sec.
Space: 368932 Bytes
GC: 1, GC time: 0.06 sec.

Time for test4

Real time: 0.840718 sec.
Run time: 0.77 sec.
Space: 210532 Bytes

------------------------------------------

GCL version 2.1  (Aug 13 1995)

Time for fill-diff-dist-table
real time : 19.830 secs
run time  : 19.810 secs


Time for test1
real time : 1.150 secs
run time  : 1.140 secs


Time for test1a
real time : 1.260 secs
run time  : 1.260 secs


Time for test2
real time : 18.460 secs
run time  : 18.460 secs


Time for test3
real time : 17.130 secs
run time  : 17.130 secs


Time for test4
real time : 8.670 secs
run time  : 8.670 secs


------------------------------------------

MzScheme version 47

Time for fill-diff-dist-table
cpu time: 1930 real time: 1927 gc time: 110


Time for test1
cpu time: 90 real time: 89 gc time: 0


Time for test1a
cpu time: 120 real time: 125 gc time: 0


Time for test2
cpu time: 1840 real time: 1921 gc time: 80


Time for test3
cpu time: 1820 real time: 1811 gc time: 100


Time for test4
cpu time: 1240 real time: 1243 gc time: 20

|#
