;#ifdef SCHEME
;; MzScheme/MrEd configuration file for NanoCAD
;#else
;; Common Lisp configuration file for NanoCAD
;#endif

;#ifdef SCHEME
;#define DEFCONST(x,y)  (define x y)
;#define TRUE  #t
;#define FALSE #f
;#else
;#define DEFCONST(x,y)  (defconstant x y)
;#define TRUE  t
;#define FALSE nil
(defmacro define (name-args &rest body)
  (cond ((listp name-args)
	 `(defun ,(car name-args) ,(cdr name-args) ,@body))
	(t
	 `(defvar ,name-args ,@body))))
;#endif

DEFCONST(true, TRUE)
DEFCONST(false, FALSE)

;#ifdef DEBUG
DEFCONST(debugging, TRUE)
;#else
DEFCONST(debugging, FALSE)
;#endif

;#ifdef USE_MRED
DEFCONST(use-mred, TRUE)
;#else
DEFCONST(use-mred, FALSE)
;#endif

;#if defined(SCHEME)
(define-macro make-lambda (lambda (args . body) `(lambda ,args ,@body)))
(define-macro funcall (lambda (lexp . args) `(,lexp ,@args)))
(define-macro func (lambda (x) x))
(define-macro mapcar (lambda (f lst) `(map ,f ,lst)))
(define-macro qsort (lambda (x y) `(quicksort ,x ,y)))
(define-macro labels
  (lambda (defns . body)
    `(let
	 ,(map
	   (lambda (x)
	     (list (car x) (cons 'lambda (cdr x))))
	   defns)
       ,@body)))

(define-macro dolist
  (lambda (args . body)
    `(do ((local-list ,(cadr args) (cdr local-list))
	  (,(car args) '()))
	 ((null? local-list))
       (set! ,(car args) (car local-list))
       ,@body)))

(define-macro dotimes
  (lambda (args . body)
    `(do ((,(car args) 0 (+ 1 ,(car args)))
	  (iteration-limit ,(cadr args)))
	 ((>= ,(car args) iteration-limit))
       ,@body)))

;#ifdef DEBUG
(define-macro dbgprintf
  (lambda (x . y) `(printf ,x ,@y)))
(define-macro entering
  (lambda (name) `(printf "Entering ~s~%" ,name)))
;#else
(define-macro dbgprintf
  (lambda (x . y) '()))
(define-macro entering
  (lambda (name) '()))
;#endif

;#else  /* !defined(SCHEME) */
(defconstant else t)
(defmacro list-ref (lst n) `(nth ,n ,lst))
(defmacro make-lambda (args &rest body) `#'(lambda ,args ,@body))
(defmacro func (x)  `#',x)
(defmacro real-part (x) x)
(defmacro printf (fmt &rest args) `(format t ,fmt ,@args))
(defmacro set! (var value) `(setf ,var ,value))
(defmacro equal? (x y) `(equal ,x ,y))
(defmacro null? (x) `(null ,x))
(defmacro vector-ref (v n) `(svref ,v ,n))
(defmacro vector-set! (v n value) `(setf (svref ,v ,n) ,value))
(defmacro defined? (x) `(boundp ,x))
(defmacro qsort (x y) `(sort ,x ,y))
(defmacro eq? (x y) `(eq ,x ,y))
(defmacro fprintf (f &rest args)
  `(format ,f ,@args))

(defun make-vector (n) (make-array (list n)))
(defun open-input-file (name)
  (open name))
(defun open-output-file (name)
  (open name :direction :output :if-exists :supersede))
(defun close-input-port (name)
  (close name))
(defun close-output-port (name)
  (close name))

;#ifdef DEBUG
(defmacro dbgprintf (x &rest y)
  `(format t ,x ,@y))
(defmacro entering (name)
  `(format t "Entering ~s~%" ,name))
;#else
(defmacro dbgprintf (x &rest y) nil)
(defmacro entering (name) nil)
;#endif

;#endif  /* defined(SCHEME) */
