;; Common Lisp configuration file for NanoCAD

(defmacro define (name-args &rest body)
  (cond ((listp name-args)
	 `(defun ,(car name-args) ,(cdr name-args) ,@body))
	(t
	 `(defvar ,name-args ,@body))))

(defconstant  true    t  ) 
(defconstant  false    nil  ) 

(defconstant  debugging    nil  ) 

(defconstant  use-mred    nil  ) 

(defconstant else t)
(defmacro list-ref (lst n) `(nth ,n ,lst))
(defmacro make-lambda (args &rest body) `#'(lambda ,args ,@body))
(defmacro func (x)  `#',x)
(defmacro real-part (x) x)
(defmacro printf (fmt &rest args) `(format t ,fmt ,@args))
(defmacro set! (var value) `(setf ,var ,value))
(defmacro equal? (x y) `(equal ,x ,y))
(defmacro null? (x) `(null ,x))
(defmacro vector-ref (v n) `(svref ,v ,n))
(defmacro vector-set! (v n value) `(setf (svref ,v ,n) ,value))
(defmacro defined? (x) `(boundp ,x))
(defmacro qsort (x y) `(sort ,x ,y))
(defmacro eq? (x y) `(eq ,x ,y))
(defmacro fprintf (f &rest args)
  `(format ,f ,@args))

(defun make-vector (n) (make-array (list n)))
(defun open-input-file (name)
  (open name))
(defun open-output-file (name)
  (open name :direction :output :if-exists :supersede))
(defun close-input-port (name)
  (close name))
(defun close-output-port (name)
  (close name))

(defmacro dbgprintf (x &rest y) nil)
(defmacro entering (name) nil)

