;; MzScheme/MrEd configuration file for NanoCAD

(define  true    #t  ) 
(define  false    #f  ) 

(define  debugging    #f  ) 

(define  use-mred    #f  ) 

(define-macro make-lambda (lambda (args . body) `(lambda ,args ,@body)))
(define-macro funcall (lambda (lexp . args) `(,lexp ,@args)))
(define-macro func (lambda (x) x))
(define-macro mapcar (lambda (f lst) `(map ,f ,lst)))
(define-macro qsort (lambda (x y) `(quicksort ,x ,y)))
(define-macro labels
  (lambda (defns . body)
    `(let
	 ,(map
	   (lambda (x)
	     (list (car x) (cons 'lambda (cdr x))))
	   defns)
       ,@body)))

(define-macro dolist
  (lambda (args . body)
    `(do ((local-list ,(cadr args) (cdr local-list))
	  (,(car args) '()))
	 ((null? local-list))
       (set! ,(car args) (car local-list))
       ,@body)))

(define-macro dotimes
  (lambda (args . body)
    `(do ((,(car args) 0 (+ 1 ,(car args)))
	  (iteration-limit ,(cadr args)))
	 ((>= ,(car args) iteration-limit))
       ,@body)))

(define-macro dbgprintf
  (lambda (x . y) '()))
(define-macro entering
  (lambda (name) '()))

