FLAGS = -O2 -Wall
# FLAGS = -g -Wall
# FLAGS = -g -DDEBUG -Wall

main:
	(cd c; make main)
	cp c/main .

menu:
	(cd c; make menu)
	cp c/menu .

clean:
	rm -f core libmol.a *.o *~ main menu data
	(cd c; make clean)
	(cd c++; make clean)

tgz:
	make clean
	(cd ..; tar cf - verlet | gzip > verlet-fun.tar.gz)

zip:
	make clean
	mkdir verlet
	mkdir verlet/c
	mkdir verlet/c++
	for x in `ls`; do unix2dos < $$x > verlet/$$x; done
	for x in `ls c`; do unix2dos < c/$$x > verlet/c/$$x; done
	for x in `ls c++`; do unix2dos < c++/$$x > verlet/c++/$$x; done
	zip -r ../verl-fun.zip verlet
	rm -rf verlet
