/*
 *  Groups of atoms, and interesting operations on them
 */

/* This is a cheesy way to do this and should be replaced, but it will do
 * for now, to place a limit on numbers of atoms, bonds, and terms, and
 * to declare arrays for them. Later I'll try to think of some more clever
 * arrangement so that these arrays can grow dynamically, and not have some
 * fundamental limit on their size.
 */

#define MAX_NUM_ATOMS 3000
#define MAX_NUM_BONDS 5000
#define MAX_NUM_TERMS 10000

class group
{
  atom *atoms[MAX_NUM_ATOMS];
  bond *bonds[MAX_NUM_BONDS];
  term *terms[MAX_NUM_TERMS];
 public:
  group ();
  int atom_count;
  int bond_count;
  int term_count;
  void add_atom (atom * a);
  void add_bond (bond * b);
  void add_term (term * t);
  atom *choose_atom (int index);
  bond *choose_bond (int index);
  term *choose_term (int index);

  /* total group energy is the sum of atoms' kinetic energies and terms'
   * potential energies. dampers dissipate energy and do not contribute
   * to this sum.
   */
  double energy ();

  /* iterate atom motions, zero atom forces, compute term forces for new
   * positions of atoms
   */
  void physics_time_step (double dt);

  /* apply a test to all the atoms in this group, those that test
   * true are added to the 'selected' group. 'selector' should return
   * a boolean.
   */
  void select_subgroup (group * selected,
			int (*selector) (atom * atm, int index));

  void apply_to_atoms (int (*do_this) (atom * a));
  void apply_to_terms (int (*do_this) (term * t));

  /* this is a slow operation [O(n^2) in number of atoms] so don't
   * do this very often for large structures
   */
  void infer_bonds_from_distances ();
};
