/*
 * Hacking atoms
 */

#ifndef ATOM_H
#define ATOM_H

enum SPECIES
  {
    C_SP3, C_SP2, C_SP, H, N_SP3, N_SP2, N_SP, O_SP3, O_SP2
  };

typedef struct
  {
    enum SPECIES species;
    double mass, charge, evdw, rvdw;
    double x[3], v[3], f[3];
  }
atom;

extern void zero_force (atom * a);
extern void iterate_motion (atom * a, double time_step);
extern double kinetic_energy (atom * a);
extern void
  init_atom (atom * a, enum SPECIES species, double charge,
	     double x0, double x1, double x2);

#endif
